META
key;value
description;District PB in Warszawa, Włochy
country;Poland
unit;Warszawa
district;Włochy
subunit;Włochy
instance;2024
num_projects;59
num_votes;1754
budget;1724261
vote_type;approval
rule;greedy
date_begin;15.06.2023
date_end;30.06.2023
max_length;15
edition;10
language;pl
currency;PLN
comment;#1: The metadata regarding the age of voters shows very low values (starting from zero), indicating that one doesn't need to be an adult to vote: If a voter is under 13, they can vote with the consent of a parent or guardian. Hence, for example, age 0 likely corresponds to cases where parents/guardians are voting on behalf of their children. #2: Due to a voting system glitch, twelve voters mistakenly cast ballots for projects in two different districts, violating regulations. To align with city-wide results, we tagged these voters with the prefix 999999 and separated their ballots into two distinct votes. The final election outcome was not affected.
PROJECTS
project_id;cost;votes;name;category;target;selected;latitude;longitude
1311;199000;887;Więcej zieleni dla Włochy - krzewy, trawy i byliny ozdobne oraz rośliny cebulowe;environmental protection,public space,urban greenery;children,seniors;1;52.20034799605713;20.93544960021973
1545;97000;867;Ratujmy pszczoły. Nasadzenia krzewów miododajnych.;education,culture,environmental protection,public space,urban greenery;children,seniors;1;52.20893822334987;20.923193693161014
1245;126350;866;Nie jesteś sam - pierwsza pomoc psychologiczna dla dzieci i młodzieży;education,welfare;children;1;52.19523120261734;20.937205553054813
1421;120000;707;Nie dla Wenecji we Włochach;public transit and roads,public space;children,seniors;1;;
1136;5500;700;Wróble, sikorki i pszczoły;environmental protection,public space,urban greenery;children,seniors;1;52.2006924;20.9475868
1057;98000;675;Kino letnie w Parku Kotańskiego oraz nad Stawami Cietrzewia;culture,public space;children,seniors;1;52.19842491285871;20.94827413548046
178;120000;674;Zakup nowości wydawniczych dla bibliotek w Dzielnicy Włochy;education,culture;children,seniors;1;52.1945050875;20.945631554711785
1576;24000;635;Więcej koszy na śmieci;environmental protection,public space;children,seniors;1;52.20506945915201;20.92651426792145
1611;250000;619;Modernizacja integracyjnego placu zabaw w Parku Kombatantów;culture,environmental protection,public space,sport,urban greenery;children;1;52.20741206284817;20.91181039810181
1588;49900;593;Bezpieczniejszy Park Kombatantów - monitoring;public transit and roads,environmental protection,public space;children,seniors;1;52.20631802204061;20.91453552246094
1280;30000;556;Zimowe dokarmianie ptactwa we włochowskich parkach oraz w karmnikach dla ptaków w przedszkolach i włochowskich szkołach;education,environmental protection,public space,urban greenery;children;1;52.19492982261071;20.944393873214725
1128;102000;554;Zielone parkany we Włochach;environmental protection,public space,urban greenery;children,seniors;1;52.20618181;20.918168468870704
506;112600;502;Zdrowo i na sportowo - cały rok zajęcia sportowe dla mieszkańców dzielnicy na powietrzu i w salach: callanetics, zdrowy kręgosłup, pilates, joga, gimnastyka dla seniorów, aerobic, boks, nordic walking, tai chi.;sport;seniors;1;52.198021265385194;20.937856039354134
482;63750;497;Nasadzenia krzewów, bylin i roślin cebulowych oraz ustawienie koszy na śmieci przy Rondzie Miasta Ogrodu Włochy;education,public space,urban greenery;children,seniors;1;52.196835536931765;20.923476218958967
1644;145000;496;Fort V Włochy żyje. Pikniki sąsiedzkie, yoga i turniej piłkarski;culture,public space,sport,urban greenery;children,seniors;1;52.195486618684676;20.914235115051273
1131;75900;484;Kwiatowe wyspy Instalatorów;public transit and roads,environmental protection,public space,urban greenery;children,seniors;1;52.2006924;20.9475868
1563;300000;445;Zielony Skwer Chrobrego czyli jak poprawić okolice Zapustnej i Tynkarskiej;public transit and roads,environmental protection,public space,urban greenery;children,seniors;0;52.2003739651206;20.901403427124027
1135;37000;444;Dziewczyny dziewczynom. Warsztaty motywacyjne, asertywność i samoobrona dla kobiet - edycja III;education,culture,sport;;1;52.190143425;20.93165027978401
1002;300000;402;Glinianka Podwójna przy ul. Cegielniana w nowej odsłonie.;environmental protection,public space,urban greenery;children,seniors;0;52.20844822057699;20.923848152160648
1168;50000;389;Pasy na ulicy Globusowej;public transit and roads;children,seniors;1;52.2102878;20.912798652009382
204;20000;369;Zakup gier planszowych i puzzli dla Biblioteki Publicznej w Dzielnicy Włochy m.st. Warszawy;education,culture;children,seniors;0;52.194903749999995;20.946446350000002
1139;12000;362;Stacja do naprawy roweru;public transit and roads,environmental protection,sport;children,seniors;1;52.18441585;20.972844533740634
480;99000;360;Nowe kosze na śmieci w okolicy Fortu V Włochy;public space,urban greenery;children,seniors;0;52.19719740799849;20.915393829345707
162;6200;334;Lustro drogowe - Łopuszańska 95;public transit and roads;children,seniors;1;52.19503415650203;20.931916236877445
1493;222000;326;Rekultywacja zbiornika wodnego – Staw Zbarski, Okęcie;environmental protection,public space,urban greenery;children,seniors;0;52.179856917634424;20.983779430389408
720;10000;316;Park dla Okęcia (kontynuacja);public transit and roads,public space,sport,urban greenery;children,seniors;0;52.18703639608137;20.94852447509766
1412;28000;275;Letnie teatrzyki dla najmłodszych w Parku Kotańskiego;education,culture,public space,urban greenery;children,seniors;0;52.196033775392564;20.967407226562504
1585;90000;262;Zielona kieszonka przy Urszuli i Dekarskiej;public space,urban greenery;children,seniors;0;52.20600635198119;20.902283186831628
1265;51900;261;Łyk świeżego powietrza w OSiR Włochy;sport;children,seniors;0;52.18792675;20.960689726727736
160;6000;251;Latarnia- ul. Jutrzenki 132;public transit and roads,public space;children,seniors;0;52.196308;20.931471545194782
1594;40000;244;Otwarte sale gimnastyczne dla mieszkańców (Starych Włoch) - LO nr CLIX Solipska;education,culture,sport;children,seniors;0;52.2006303;20.910592470060376
363;42000;233;Kolorowe ławki na korytarzach szkolnych;education,culture;children;0;52.2100325;20.9039022
242;20000;232;Teatrzyki w bibliotece;education,culture,public space;children;0;52.20653540230345;20.912218093872074
447;7500;228;Miasto Ogród Literatury – spotkania autorskie we włochowskich bibliotekach;education,culture;children,seniors;0;52.200823;20.918375420740404
486;35500;227;Stacja pogody: obserwuję, doświadczam, rozumiem;education,environmental protection,urban greenery;children,seniors;0;52.21022515;20.904299731534657
115;7500;220;Stojaki na rowery na Astronautów;environmental protection,public space,sport;children,seniors;0;52.183358489024414;20.973565578460697
1590;40000;208;Otwarte sale gimnastyczne dla mieszkańców (Okęcie) = <SP88 i SP87>;education,culture,sport;children,seniors;0;52.18452426563684;20.95324516296387
1591;40000;206;Otwarte sale gimnastyczne dla mieszkańców (Nowych Włoch) - ZS 17;education,culture,sport;children,seniors;0;52.2101757;20.904257676350547
1069;20000;205;Wytańcz smukłą sylwetkę;sport;;0;52.2074645;20.9078284
726;9000;186;Kosze na śmieci na ul. Salomejskiej i ul. Jutrzenki;environmental protection;children,seniors;0;52.18678283487494;20.92512130737305
1612;104000;181;Nowoczesna edukacja- uczmy nasze dzieci na monitorach interaktywnych!;education,culture;children;0;52.195743283333336;20.94772695383484
1671;30500;180;Piknik Rodzinna sobota;education,culture,public space;children,seniors;0;52.1922709;20.96586253375098
1141;45100;173;Zajęcia typu Cross w plenerze we Włochach - edycja II - zajęcia łączące w sobie sporty siłowe, gimnastykę oraz sporty wytrzymałościowe.;education,sport;;0;52.196460300000005;20.923044822170947
574;2500;170;Bawmy się aktywnie – zakup gier plenerowych;culture;children;0;52.1949878;20.9246655
581;20000;169;Darmowe pokazy w Klubie Miłośników Filmu;culture;seniors;0;52.20729108836386;20.90805530548096
1353;15800;155;Zajęcia umuzykalniające dla dzieci w wieku 1-3 lata;education,culture;children;0;52.2082458;20.91681851157618
1032;40000;154;Rozświetlona Okęcka;culture,public space;children,seniors;0;52.194744788943446;20.968136787414554
1382;20000;149;Bezpieczna droga do żłobka - zmiana organizacji ruchu na ul. Nike na jednokierunkowy;public transit and roads,public space;children,seniors;0;52.21071555349077;20.91429948806763
1625;10000;146;Słup ogłoszeniowy dostępny dla wszystkich;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;52.20158511477517;20.935864448547367
1473;90000;139;Siłownia pod chmurką – Staw Zbarski, Okęcie;public space,sport;seniors;0;52.17987928557088;20.983629226684574
1553;71000;138;Poradnik architektoniczny - Włochy;culture,public space;seniors;0;52.19217064991143;20.95923185348511
1356;36100;129;Rośnijmy razem we Włochach - program warsztatów dla rodziców najmłodszych dzieci w dzielnicy Włochy;education;children;0;52.188352800000004;20.972290979372183
1244;35000;123;Progi zwalniające na ulicy Sabały.;public transit and roads,public space;children,seniors;0;52.18642834933051;20.956977009718685
576;7500;118;Literatura na pokładzie – spotkania autorskie w okęckich bibliotekach;education,culture;children,seniors;0;52.188183249999994;20.97293415
1596;10000;109;Zakup podręczników do gier RPG!;education,culture;children,seniors;0;52.194903749999995;20.946446350000002
1573;201730;104;Książkomat na Niskim Okęciu;education,culture;children,seniors;0;52.17733060233608;20.940520763397217
1626;108000;99;Hiphopowa bitka skateparkowa;culture,sport;;0;52.210244345336136;20.891146659851074
1561;35000;89;Wspólnota czyli wspólnie - rodzinnie na lokalne wydarzenia, Mamo i Tato to projekt dla Was;education,public transit and roads,culture,environmental protection,welfare,public space,sport,urban greenery;children,seniors;0;;
1024;25000;40;Tablica informacyjna o Antonim Nowakowskim;public space;children,seniors;0;52.20179429880062;20.923461914062504
VOTES
voter_id;vote;age;sex
72;204,1141,1280,1493,1671,1545,1265,1421,1136,1135,581,1057,178,506,1245;36;F
443;204,1057,1671,1412,1265,1590,506,1069;37;F
483;1135,160,178,1545,1280,506,447,1594,1576,1069,1245;20;F
555;1024,1545,1311,1421,486,1611,1245,1069;33;F
568;1612,160,1311,726,1168,242,1356,480,720,204,115,1139,1473,1671,1032;43;M
573;1024,1644,1139,1625,480,1311,1553,1421,1611,1576,1168,1057,1280,482,1588;49;M
585;1131,1280,1057,1002,1128,1611,1139,178,447,726,162,1421,1576,482,1311;31;M
607;506,1245,178,1412;39;F
668;1671,1421,1473,1412,1265,506;68;F
696;1057,1311,1135,1139,1588,480,1168,1644,1382,1280,1625,1576,1069,363,1493;43;F
698;1588,1168,1311,1382,1421,1611,1576;29;M
735;1611,1561,1057,480,1356,1135,1612,178,162,1644,1421,1625,1353,1245,1576;35;F
736;178,1353,115,1591,1280,1590,1493,1057,1545,506,1245,363;46;F
749;1057,1421,1136,1563,482,204,178,1245,363;35;M
763;1563,204,242,1588,1311,1057,178,1644,1128,1611,482;33;F
792;1588,1168,1311,1612,178,1561,1671,1545,1644,1002,574,1353,1136,506,1611;34;F
910;1576,482,178,480,242,1588,1057,1561,1412,1644,1002,1421,1563,1611,1245;32;F
943;178,1671,574,506,1245,363;40;F
957;1591,574,1128,204,1131,1311,1553,1545,1596,1280,1421,1136,486,1245,1576;26;M
1031;178,1585,1057,1168,480,720,1588,1311,1545,1644,1280,1421,1136,1611,1245;39;F
1090;1473,1131,1135,720,1128,1573,1493,1069,1576,1245,162,160,1311,726;25;F
1121;1644,1265,1245,1573,1493,1135,1057,178,1545,1412,1032,1590,506,1611,363;41;F
1174;1135,1131,1612,1563,204,1168,1311,178,1585,1545,1421,1611,1245,1594,482;39;F
1200;1311,1473,1131,726,1168,1135,1024,1588,204,1356,115,1139,1382,1280,1245;34;F
1323;1588,1545,1136,1563,1611,1245;41;M
1337;1057,1280,1421,1136,447,482,1611,1245,1069,1168,178,1591,1141,1545,506;44;F
1351;162,1473,1131,115,720,1139,726,160,1671,1265,1626,1032,1245,1576,1069;50;F
1352;1644,1136,1611,1311,1245;35;M
1380;1612,1591,1141,1671,1545,1128,574,1280,1136,486,1590,506,1611,1576,1588;38;M
1520;1057,160,178,1002,1128,1265,1136,1588,1280;42;M
1524;1128,1280,1002,1412,1585,1612,1311,1168,1139,1588,1591,1545,506,1611,1245;49;F
1536;482,1576,1280,1002,1545,720,115,480,1473,1644,1128,1625,1131,1136,1311;29;M
1565;242,1141,1545,1136,506,1563,1611,1245;38;F
1611;1311,1131,726,720,1576,1493,1136,1585,160,1135,480,1588,1545,1280,482;39;M
1615;1421,162,1131,1311,160,1128,486,1611,1576;30;M
1653;115,480,1139,1588,1168,726,1473,1311,160,1585,1545,162,1128,1421;30;M
1654;1245,1136,1421,1244,1128,1382,1002,1644,1545,1585,160,1311,1131,1168,1139;27;M
1696;1131,1311,1553,1168,581,1585,1136,1626,1611,1245,482;27;M
1789;1356,242,480,115,720,1588,726,1131,1311,1057,160,1136,1611,1576,1493;25;F
1831;1131;27;F
1903;1493,1069,447,506,576,581,1311,1135,204,178,1545,1002,1280,1625,1421;66;F
1926;1356,1131,178,162,1265,1576,1493,1057,1545,1412,1644,1128,506,1611,482;39;M
1941;1128,1168,1563,1585;48;M
1954;720,1588,726,1131,1473,1311,1057,160,1612,1382,1136,1611,1576,482,1493;27;M
1993;480,1168,162,1473,726,1139,1131,1553,160,1591,1265,1594,1576,1311,1136;31;M
1997;1265,1032,447,1382,1576,363,115,1588,1139,1135,1131,576,1421,1245;43;F
2074;1644,1382,1128,576,1136,482,1493,1131,726,1024,480,160,162,1244,1576;44;F
2190;1168,1588,115,1576,1244,1493,1553,162,1265,1136,1131,1245,1280,1311,720;35;M
2262;480,1057,162,1644,1002,1128,506,1611,1245,1576,482;38;M
2311;204,242,1588,1135,1057,178,1561,1671,1545,1412,1280,1353,1136,506,1611;46;F
2338;160,1473,726,1024,480,1545,162,1644,1280,1576,1069,1493,1421,1136,1590;32;M
2401;1382,1612,204,1135,1311,1591,178,1545,1421,1626,506,1611,1594,1576,1069;36;F
2467;1588,1136,1563,482,480,720,726,1168,1311,1057,160,162,1128,1576,1131;33;F
2536;1356,1265,1421,1353,506,1611,1069,482,1573,1493,720,726,1311,1245,1576;32;F
2820;480,1311,1563,1576,363;39;F
2947;1611,1591,1265,1563,1421,1128,1280,1002,1545,1585,1311,1131,1168,482,480;25;M
2948;1245,1002,1545,1553,1311,1139,480,1588,1135,178,1280,1128,1625,506,1069;51;F
2997;486,1245,363,1576,1136,1421,1545,480;22;F
3001;1588,162,1002,1128,1563,1611,1245,1576,363;43;F
3062;1032,1244,1128,1002,162,1057,726,1168,1135,1588,480,720,1131,1311,1644;34;F
3082;1588,1168,1311,178,1585,162,1002,1128,1625,1136,1611,447,1245,482;39;F
3327;363,482,1245,1576,1311,178;45;F
3418;1168,160,1585,1545,1382,1002,1128,1244,1136,1576,480,1311,162,1421,482;31;M
3471;480,1139,1168,726,1311,1057,1644,1002,1280,1128,1136,1563,1576,482,1493;29;F
3628;160,1585,1644,1057,1311,726,1588,480,1421,1563,1611,1576,482;36;M
3644;1135,482,1139,1356,480,720,1588,1168,1131,160,1644,1002,1421,1353,1611;29;F
3684;1057,1585,1128,1265,1136,1576,1311,1141,1545,162,1002,1280,1421,1245,482;38;M
3692;204,720,1131,1311,160,178,1545,1412,1280,1265,1136;32;F
3758;506,1611,1576,242,1561,1671,1545,1412,1644,1136,1353,1245,363,482,1069;28;F
3834;1356,178,1671,1128,1596,1412,1245,1545,1135,1057,1280,1136,1032,1590,506;43;F
3927;480,720,1139,1473,1493,1644;25;M
4090;1311,1585,1002,1128,482,1588,178,1591,1141,1644,1611,447,1245;63;F
4179;1265,1135,506;46;F
4210;1136,1576,115,720,1139,1131,1311,1057,178,162,1128,1244,1032,1590,506;66;F
4221;720,1139,1135,1473,1311,1057,1644,1002,1421,1136,1590,506,1563,1611,1069;29;F
4277;581,1311,1135,242,1168,1057,178,1644,1280,1136,506,1611,447;60;F
4299;1625,486,1032,1576,482,1311,178,1591,1545,1265,1136,1590,506,1245,1594;35;F
4303;1356,1139,1057,1545,1245,1576,482;32;F
4553;480,1588,1168,1311,1612,178,1545,1596;45;M
4610;1421,482,1493,726,160,1585,1128,1244,1563,1576,1002,1545,1311,1168,1131;36;M
4683;1131,1057,1596,1128,482,1576;28;M
4759;162,1128,1265,506,1576,1069,1545,1057,1588,480,204,178,1644,1563,1594;49;F
4777;1311,1135,1131,160,1280,1421,1136,1576;29;M
4883;1553,178,1280,486,1590,1245,447,720,1311,1545,162,1128,576,1136,1573;35;F
4884;1280,720,480,1032,1493,726,1131,1311,1585,1545,1128,1136,1563,1576,482;35;F
4885;1002,1128,1421,1136,1563,1493;34;M
4916;1576,1139,1244,726,1168,115,1135,178,1421,1493,162,160,1311,720,1588;26;F
4925;1585,581,1139,1588,1311,1057,1612,1591,1561,1671,1644,506,1611,1576,1493;32;F
5285;1135,1131,1644,1136;42;F
5381;1493,482,486,1136,1625,1280,1002,1545,1311,1131,1135,720;21;F
5519;1265,1421,1131,1057,1545,506;31;F
5615;726,1131,1588,115,480,1139,1128,1244,1421,1563,1611,1594,482,1493,1576;23;M
5688;1032,1356,1057,506,1280,1412;49;F
5962;1131,1265,1590,506,1594;54;F
5966;1139,480,115,1280,1128,482,1611,1563,1136,1421,1002,162,1545,160,1588;35;M
5969;204,720,1139,1135,1131,1311,1057;26;F
6022;1131,1311,1136;27;M
6057;1563,1244,1128,1002,1545,480,1493,115,1168,1131,1311,1553,1421,1245,1382;19;M
6091;1545,1473,480,720,115,1139,1135,1311,1553,160,1625,1136,1245,1069,1573;30;F
6279;1353,1412,1671,1561,1141,1057,1311,1131,1135,1493;34;F
6315;1356,1135,1353;36;F
6568;1671,1057,1588;36;M
6613;1493,1625,1128,1612,1141,162,1265,1136,486,1590,1245,1576,363,720,1644;42;M
6731;1311,1612,178,363;46;F
6813;480,720,1311,1545,162,1002,1128,1244,1421,1136,1563,1611,1576,482,1493;45;M
6866;720,1588,1131,1311,1057,1245;28;F
6874;160,1545,1280,1128,1136,1245,1493,482,1553,1135,1131,1311,1421,506,1069;39;F
6955;1069,1563,482,1576,1245,1611,1421,178,1057,1311,1168,1588,242,204,1002;38;F
7101;720,480,581,1131,242,1588,1311,1057,1545,1280,1421,1136,1611,1576;30;M
7115;1168,1131,1311,1553,1585,1545,1280,1136,1563,1611,447,1245,1576,482,178;27;F
7161;720,1644,506;38;F
7415;1644;43;F
7635;1168,1311,1057,178,1545,1002,1280,1136,1576,1493;49;M
7757;1245,1611,1311,204,178,1545,1136,1576;36;F
7922;1136,1131;26;F
7961;720,1131,1128,1265,1032,1245,482,1139,1311,1493;32;F
8062;480,720,1139,726,1311,1245;34;F
8134;1131,1553,1280,1136,1245;40;M
8299;204,115,1545,1280,1136,363,1493;33;F
8322;1280,1128,576,486,1245,1576,1573;44;F
8412;1545,178,204,1311,1644,1002,1585,1588;46;M
8438;1588,1057,1128,1421,1136,1563,1611,1245,1594;38;M
8565;1545,178,506,1069;50;F
8743;1611,1069,1139,1141,506;43;F
8762;720,480,726,1576,1493,1311;35;F
8810;1024,1057,1576,482,1644,506,1128,1594,480,1280,574,1596,178,204,1563;48;M
8922;1136,1421,1412,162,581,1139,1311,1057,1545,1128,1625,506;37;F
8941;1245,115,204,1135,1057,178,1591,1141,1671,1545,1644,1128,1265,506,1069;39;F
9147;1168,1591,1002,1280,1136,486,1611,1245,1594,363;45;F
9149;1594,1611,1590,1421,1128,1382,1545,1135,1131,1057,162,1136,1245,1576;34;F
9187;1265,1057,1131,506,1069;29;F
9222;1493,1573,1611,1131,1473,178,1057,720,1644,1245;42;M
9322;486,1611,1245,1576,204,480,1356,1311,1612,1141,1561,1671,1545,1412,1644;40;F
9368;482,1493,204,720,480,1588,1139,1135,1311,1057,1612,178,1644,1611,1245;32;F
9414;1265,1135,1473,576,506,1493;46;F
9475;1168,1545,1611,1245;23;F
9495;1057,1545,1412,1280,1136,1590,1245;25;M
9596;1576,726;31;F
9707;1576,1585,1245,1493,1280,1002,1136,1057,178,1545,576,447,1135,242,204;45;F
9843;1576,1563,1545,178,1168,1588;38;F
10093;720,1311,1141,162,1644,1128,1244,1265,1421,486,1032,1590,506,1576,1573;32;F
10152;480,574,1596,1136,1131,1311,178,1545,1280,1128,1563,1611,1245,482,204;38;F
10173;1545,1588,1135,1057,1591,1141,1412,1280,1265,1625,1136,1032,1590,506,1594;49;M
10180;1561,1545,1382,1244,1136,363,1057,178,1412,574,486,1576,506,1245,1573;32;F
10259;162,1245,1493,1594,1473,1421,160,1131,720,204,1139,1590,1553,506,1265;31;M
10289;480,1588,1311,482,204,178,1545,574,1128,1563,1611;38;M
10478;178,1576,482,1311,1588,1356,242,1168,1553,1585,1671,1644,1002,1563,1611;32;M
10525;1311,506,1002,1280,1135,1168,447,1245,480,1057,178,1644,1563,1594,482;61;F
10552;1139,1356,1493,482,1421,115,1131,1311,1545,162,1382,1128,1136,1576,720;31;F
10603;1590,506;39;M
10606;1131,1002,1245,1135,1311,1057,178,1545,1644,1128,1136,1563,447,482;60;M
10686;1311,1131,1588,1356,720,204,115,1139,1135,178,1141,1545,1412,1265,506;37;F
10765;1311,1265,1591,506,1069,363;38;F
10772;480,363,1245,1611,1421,1382,1671,1561,178,1612,1311,1131,1135,1588,204;32;F
10831;1057,160,1141,1545,162,1644,1265,1421,1136,486,1626,506,1245,1594,1069;15;F
10864;1585,1545,1128,1245,1493,1421,1311,720,1131,1563,1136;31;F
10868;1265,482,1311,1612,1644,1421,1280,178,1588,1168,1128,1576,1585,1611,1563;32;F
10907;1585,720,1588,726,1131,1311,160,1280,1128,1421,1563,1611,1576,482,1493;33;M
11187;1588,1311,1057,160,1585,1545,162,1280,1421,1245,482;30;F
11294;1131,1135,1139,1421,576,1128,574,1412,1545,1553,1057,1311,720,204,115;40;F
11303;178,160,1057,1311,1473,1168,242,1588,1612,1128,1611,363,1545,486,1245;31;F
11375;574,1644,1671,1561,178,1612,1024,1588,1168,1311,1057,1553,1382,1002,1421;50;F
11428;581,1553,178,1412,1644,1421,482,1311,1545,1596,1280,1353,1136,1626,1245;27;M
11437;1421,1563,115,720,480,1588,1139,1131,1311,1057,160,1545,162,1136,1576;32;M
11614;480,363,1135,1139,1057,1545,1644,1136,506,1563,447,1245,1594,1576,482;40;F
11872;178,482,162,1421;44;M
12150;115,1576,1545,1002,1311,1280,506,1168,1493,480,1588,1057,1128,1421,1611;37;M
12346;726,1545,1002,1563,1245,1576;55;F
12418;1421,1311,581,1356,480,204,1057,178,1553,1644,486,506,447,1245,482;38;F
12468;1561,160,726,1135,204,480,1356,1311,1057,1553,178,1545,1644,1596,1421;36;M
12640;720,1311;25;M
12667;720,726,1311,1545,1280,1136,1245,1576,482,1493;47;M
12836;1139,1168,1585,1002,1611;35;M
12910;1245,1594,1576,1545,1128,1265,1590,1573,1069,506;36;F
12967;480,720,115,1644,1625,1032,1590,1563,1611,1493,1585,1576;37;M
13092;162,1545,720,204,581,1057,178,576;41;M
13120;1591,242,720,1245,506,1612,1032,178,1356,204,1412;41;M
13147;1671,1545,1128,1265,1590,506,1611,1135,1245;35;F
13177;1136;27;F
13263;720,1057,178,162,1576,1493;35;F
13277;242,1412,574,506,1069;35;F
13348;115,720,1311;24;M
13519;1356,720,1135,726,1131,1311,160,162,1596,1382,1280,1421,1136,1611,1576;28;M
13605;726,1131,160,1545,1128,1136,1032,1576,482,1493,720,480,1311,162,1265;27;F
13631;160,1002,1128,1136,1563,1611,482,480,1588,1139,726,1311,1545,1280,1576;40;M
13669;1588,1168,1421,1611,1245;37;F
13788;1585,160,1311,1131,1135,1139,480,204,1588,1168,1057,1545,1421,1611,1563;28;F
13839;160,1563,482,1588,1168,726,1553,1644,1382,1421,506,1611,1245,1576,1069;28;M
13862;1057,1588,1135,160,1545,162,1644,1596,1128,1136,1421,1265,506,1245,1576;45;F
14065;1311,1057,1136,1563,1611,447,1069,1245,506,1545,1141,1591,178,1168,1588;71;M
14189;1244,1563,506,480,726,1473,1591,1412,1128,1353,1590,1611,1594,1576,363;51;M
14381;1356,1057,1412,1280,1032,506;47;M
14483;480,1311,1545,1644,1002,1280,1128,1421,1136,1563,1576,482;51;F
14536;1585,160,1168,1356,115,1131,1311,1057,178,1561,1545,1412,1644,1382,1128;30;F
14735;480,726,162,1421;34;M
14737;480,1057,1244,486,1576,482,1563,1611,1280,1545,178,1311,1588,1421,1245;35;M
14840;1311,1057,1141,1545,1412,1421,1136,506,363,1493;34;M
14872;1563,1245,482,1588,1135,581,1057,1553,1141,1382,1002,1421,506,1611,1069;37;F
14876;480,1493,720,1131,1473,1311,1585,1545,1002,1280,1136,1563,1611,1576,482;33;M
14941;1612,178,1626,1576,363;44;F
15047;1135,1311,1057,1141,1545,1412,1644,1280,1128,1265,1421,1136,506,1245,1131;36;F
15056;1280,1421,1136,1245,1131;34;F
15118;1311,1057,1545,1128,1611,720,1131;46;F
15130;1139,1588,480,720,204,1493,115,242,1356,1024,1473,1644,1563,1611,1576;40;M
15368;1131,1057,162,1412,1245;35;F
15412;1561,178,1612,581,1135,1139,480,1545,1644,506,1563,1611,1245,1594,1069;36;F
15522;1265,1168,1002,178,1311,1588,204,1139,1594,480,1131,1057,1644,506,1245;37;M
15589;1591,1590,1421,1139,1057,204,178,1136,1131,1576,1311;39;M
15807;1473,1057,1671,1644,1128,1626,1611,1573,1493,720,1135,1412,1421,1590,1245;30;F
15963;1311,1135,1141,1057,1280,1563,1644,482,480,506,1594,1128,1545,162,160;29;F
16016;1588,1002,1421,1576,482,1585;43;M
16140;1545,482,204,242,1588,178,1644,1002,1421,1563,1611,447,1245,1594,363;36;F
16258;1244,720,160,726,1128,1382,482,1563,480,1002,1545,1311,1588,1611,1280;28;M
16374;1588,1168,160,1545,162,1280,1136,1245;41;F
16551;1128,1591,1585,160,204,1135,1168,1131,1311,178,1545,162,1280,1421,1136;28;F
16677;1473,1311,581,1057,1585,486,1563;50;F
16753;720;32;M
16775;1245,1626,1421,1128,1280,1644,1545,178,1057,1311,1135,204,1493,1131,1553;38;F
16794;1057,1245,480,482,726,1311,160;37;F
16810;1280,1128,1265,1136,1626,506,1563,1594,1493,1135,1057,1002,1421,1611,1245;30;F
16838;1588,178,1421,1590,115,720,1473,1311,1493,162,1280,1265,1032,506,1576;67;M
16884;1473,1168,1135,720,1412,1644,1382,574,1245,1576,1057,1141,162,1545,506;33;F
16894;1473,1561,1671,1382,1128,1245,1356,1135,1311,581,1057,1644,574,506,1594;35;F
16904;1588,1311,1644,1280,1244,1563,1245,160,162,726,1493;34;M
16910;1131,1139,1135,1057,1545,1644,1265,1625,486,1590,506,1245,1576,1069,1493;41;F
17024;1356,1311,1057,160,1644,1382,1353,506,1611,1245;28;F
17026;1245,1612,1168,1135,1588,204,115,1069,482,363;16;F
17134;1573,1135,1131,581,1057,178,1141,162,576,1136,1032,506,447,1576,1069;44;F
17151;482,1311,1131,720,1128,1244,1421,1245,1057,1671,1412,1280,1136,1590,506;63;F
17263;1553,178,1625,1590,447,1131,581,1057,1612,506,162,576,1032,1576,1573;16;M
17295;480,1057,1141,506,1576;38;F
17357;1141,1245,1069,1311,1057,1591,1671,1545,1412,1644,1280,1128,1265,1353,1590;47;F
17373;204,726,1311,160,178,1141,1545,162,1382,1280,1244,1136,506,1245,1576;45;M
17495;720,480,178,162,1280,1576,363,1135,726,160,1612,1563,1245;24;F
17666;1591,1280,1128,1244,1421,506,1245,482,115,1057,1265,1590,1671,1135,1024;49;F
17732;1588,1135,1168,1311,1057,160,1244,1611,1245,1545,162,1280,1265,1421,1136;41;F
17790;1131,1545;33;M
17829;482,1576,1563,1136,1421,1311,1644;47;F
17894;726,160,162,720,1356,1135;31;F
17903;480,1588,1139,1057,178,1644,1611;43;F
17933;482,1421,1644,1311,480,204,178,1563;43;F
17943;1311,1644,1128,1265,576,1421,1563;43;M
17948;1131,1588,1139,1168,1311,1545,1136,1626,1611,1245,482,1057,1644,1563,1594;28;F
17976;1168,482,1588,1421,1311,1280,1136,1057,1002,447;30;M
17991;1168,1135,1473,1356,204,115,1421,506,1611,363,1311,1057,178,1412,1245;32;F
18017;204,115,1280,1128,1245,178,1311,1576,1588,1168,1545,1002;42;M
18079;1382,1002,1280,1128,1353,447,1576,1069,1588,1311,178,1545,1136,1611,1245;34;F
18124;486,1128,1671,1139,1588,242,1356,1311,1057,1612,178,1561,1280,1421,1245;37;F
18187;1069,1032,506,447,581,1131,1671,1128,1136,1590;60;F
18251;1057,1591,1644,1576,1131;29;F
18259;1588,726,160,162,1069;41;F
18384;486,1382,162,1545,160,1311,1473,1168,1139,1588,1612,1280,1265,1611,1245;44;M
18409;1131,1168,1139,115,1135,1311,1057,178,1591,1141,1265,1136,1590,506,1245;32;F
18440;720,204,115,480,1139,1131,1311,1057,1545,1412,1644,1128,1265,1625,1136;42;M
18556;204,1561,1644,1280,1128,1245,1576,480,242,1311,178,1545,574,1353,1611;39;F
18569;1473,726,1168,1588,1356,1024,720,1311,1057,162,1412,1382,1128,1611,1576;37;F
18595;480,1588,1311,1644,1596,574,1128,1265,1590,363,1139,1131,1612,1611,1245;36;F
18678;242,115,1311,581,1057,1136,1245,1069,506,1280,178;45;M
18707;720,1135,1553,506,1493;60;F
18709;1612,1563,1594,1576,1135,1545,1136,506,1245;37;F
18710;1644,581,720,482,1135,1131,1311,1588,1545,1002,1280,1128,1421,1136,1563;37;F
18773;1585,720,1588,1168,1131,1311,1545,162,1002,1280,1136,1611,1245,1576,482;36;M
18950;178,1136,1590;63;M
19086;720,115,1588,1168,1311,160,1585,1545,1002,1280,574,1421,1136,1611,482;38;F
19124;726,1131,1311,581,1057,160,178,162,1412,1644,1002,1128;30;F
19169;1139,480,1135,1644,1421,506,1563,1594;42;F
19193;1612,1128,1265,1421,1136,1590,1563,1594,1545,160,1311,1588,1168,1585,1611;36;F
19256;1545,1280,1244,1265,1611,1057,204,242,178,1002,576,1136,447,1245,1493;42;F
19266;574,1128,1625,1421,1626,1245,1594,1576,1069,1573,363,482,720,726,162;43;F
19301;1131,1311,581,1128,506,1135,1136,447,576,178,204,242,1057,1545,1245;45;F
19374;1625,1421,486,1136,1563,1245,1576,363,482,1493,242,1588,1168,1311,1611;34;F
19600;1168,1356,720,1493,1576,1245,506,1136,1280,1545,1612,160,1311,1131,1135;34;F
19629;1493,1576,1563,482,1421,720,1545,1131,1168,1128,1585,480,1588,1311,1002;60;F
19644;1671,1573,1356,1412,1280,506,1625,1057,178,576,1032,1590,447,1576,1493;65;F
19725;204,242,1588,1135,1168,1311,1057,1591,1141,1545,1136,506,1611,1594,1069;49;M
19745;1611,482,1588,1585,1128;35;M
19795;1245,1588,1311,1131,1545,1128,1136,1590,506;40;F
19920;1596,1128,1563,1245,115,1139,1591,1545,1644,1382,1002,1421,1136,1590,1594;19;M
20013;1545,1128,1588,204,178,1563,480,1611,482;34;M
20143;480,1002,1611,1421,1168,1588;35;M
20231;162,1421,1545,1136,1576,1311,1611,1002,1553,1588,480,1563,482,726;27;M
20411;720,1588,1139,581,1057,574,1594,363;43;F
20475;242,1356,1135,1311,1057,178,1545,1644,1002,1128,1421,506,1611,447,1245;35;F
20585;115,720,1473,1311,1545,1280,1128,1576,1493;49;F
20841;1356,1353,1611;36;F
21412;1057,1421,1032,1245;15;F
21461;204,720,1131,1311,160,178,1545,1412,1280,1265,1136;4;F
21467;1168,1131,1311,160,1585,1545,1280,1128,1421,1136,1611,1245,482;33;F
21551;480,115,720,1139,1473,1311,162,1412,1128,1244,1265,1032,506,1245,1576;39;F
21775;1135,1311,1421,1545,1002,1136,1493;43;F
21827;1353,1421,1265,1244,574,1596,1412,1545,1671,1561,1612,1057,1311,1131,1135;76;F
21849;1032,506,1611,1245,1493,115,1135,1644,1002,1421,1626,1588,1057,160,178;27;F
21902;1244,1421,486,1563,482,363,115,1168,1311,1553,1585,1545,1136,1576,1493;28;M
22062;1611,1563,1032,1353,1421,1002,162,1545,1473,720,1588,726,1311,160,1644;37;F
22113;1356,1135,1168,1002,1280,1563,482,1421,1128,1311,242,1588,1545,480,1644;40;F
22154;1280,1128,242,1356,1057,1545,1644,1382,1421,1353,1136,486,1563,1611,1245;29;F
22183;1057,1311,1139,1588,1356,242,1131,160,1545,1412,576,506,1245,363;37;F
22197;1168,1139,480,115,1588,1131,1311,160,1545,162,1280,1421,1136,1611,1245;38;F
22206;1545,1131,1135,1265,1421,1136,506;32;F
22217;1553,1612,1585,1591,1141,1128,576,1136,1611,1588,1057,178,1545,1421,486;28;F
22402;1139,1057,1141,1002,1563,1611,1594,1553,1585,506,1644,1245,1588,1382,1168;27;M
22412;1168,1131,1545,1421,1353,1563,480,1588,1311,178,1382,1280,1611,1245,1576;36;F
22506;1421,1280,1545,1671,1561,1356,204,1588,1135,1311,1057,1644,1002,1245,1576;32;F
22510;1356,242,1135,178,1545,1412,1644,1596,1280,574,1353,1136,506,1611,1245;34;F
22527;363,1611,1561,178,1612,242,1131,1311,1057,1671,1412,1644,1128,1245,1576;37;M
22626;1139,480,204,1588,1553,1057,1545,1644,1280,1128,1421,1563,447,1245,482;25;F
22703;1280,1141,178,1311,1168,1588,1057,1545,1644,1002,1128,1421,1136,1611,1245;46;F
22716;1265,1590,1493,482,363,1576,1611,1563,1421,1128,178,1588,204,1594,480;43;M
22720;480,1588,1311,1057,1141,1644,1596,1002,1421,506,1611,1245,1576,1069;43;F
22785;1611,482,1576,1002,480,1588,1139,1168,1311,1057,178,1585,1421,486,363;41;F
22830;480,1131,1057,1141,162,1644,1626,1135,1588,1545,1280,1244,1421,1136,1245;38;F
22834;1245,1057,1576,726,1644,1280,1625,506,447,1594,482,1024,160,1545,162;71;M
22870;178,1356,726,1311,1057,160,1545,162,1280,1421,1245;29;F
22874;115,1245,447,574,1596,162,160,1553,726,204,178;28;M
23041;1057,1311,1131,726,1139,1588,480,720,204,115,1545,1576,1135;33;F
23119;1245,1611,1136,574,1002,1382,1644,1545,1585,178,1311,1168,1588,242,204;34;F
23203;1545,581,1131,1588,242,1135,1311,1057,1141,162,1412,1644,506,1245,1069;41;F
23239;581,1473,1588,720,1168,1131,1311,1057,178,1671,1545,1280,1136,447,482;50;F
23252;1002,178,115,1139,160,1585,1545,162,1265,1421,1136,486,1563,1611,1245;46;F
23297;1131,1311,1057,1245;28;F
23405;1139,1611;25;F
23487;115,204,480,242,1588,1311,1057,1545,1644,1280,1563,1245;43;F
23555;1139,1311,1545,1128,506,1563,1245,482,242,1588,1057,1412,1644,1002,1611;36;F
23586;1245,1611,486,1353,1128,1545,1131,242,1356,1311,1057,178,1561,1671,1412;32;F
23785;1473,1311,581,1671,574,506,1563,1573,482,115,178,1585,1280,363;43;F
23950;1585,1563,1576,482,1311,1002;38;M
24449;1245,1128,1611,1588,178,1576;30;M
24509;720,447,576,1136;40;M
24645;204,1139,1131,1057,178,1671,1545,1421,1136,1590,1594;32;F
24663;581,1057,178,1553,1545,1625,480,482,1644;32;M
24743;1128,1588,178,1611,1245,1576;27;F
24834;242,1356,1588,1168,1311,1057,1612,1545,1412,1644,1002,1280,1128,1421,1611;40;M
24930;486,1356,1135,1131,1311,1591,1671,1545,162,1412,1280,1353,1136,506,1245;34;F
24998;204,242,581,178,1545,574,576,1032,447,1573;56;F
25011;1493,1671,574,1265,506,1245,1069,363,1356,204,242,1057,1412,1032,1590;37;F
25177;1576,1311,1131,480,720,1473,1553;23;M
25241;1135,1057,178,1545,1596,576,574,447,1573;55;F
25545;1591,1545,447,1553,1280,1563,1245,482,1588,1135,581,1057,178,1644,1421;39;F
25637;1588,1168,1311,1057,1612,178,1545,1280,1128,1421,486,1611,1245,1576,363;37;F
25646;1421,1057,178,1545,1644,1002,1280,574,480,506,447,1594,1576;48;F
25649;574,1136,1576,1069,480,1024,1135,726,1057,160,178,162,1644,506,1594;69;F
25832;204,1032,242,1356,178,1561,1671,1412,1596,1280,1265,1353,1136,1590,1245;33;F
25936;1585,1588,480,720,204,726,160,178,1545,162,1412,1421,1563,1611,1576;24;M
26006;720,1311,178,1545,1128,576,1625,1136,447;55;F
26189;204,242,1356,1588,1311,1553,178,1545,1644,1596,1002,1563,1611,1245,1576;43;M
26258;1131,1311,1585,1545,1280,1128,1136,1563,482;35;F
26310;1139,363,1057,1412,1244;39;F
26420;1585,1002,204,1611,1588,1168;51;F
26437;1168,1135,1644,1128,1421,1245,1585,1545,1136,486,1563,1611,1588,1311,1002;47;F
26551;1421,1576;23;M
26558;480,1131,726,178,162,1596,1280,1576,1421;27;M
26575;1136,1421,1280,1644,162,178,160,1057,1168,480,726,1311,1545,1576,482;40;F
26691;482,242,1588,1168,1612,178,1591,1545,1421,1136,486,1611,447,1245,363;42;M
26739;242,1588,1135,1168,1311,160,1612,178,1141,1545,1644,1421,1626,506,1611;39;F
26872;480,1135,1131,1311,1611,482,1594,1588,1168,1545,1382,1002,1128,1265,506;65;F
26887;242,1588,1168,1612,178,1591,1545,1280,1421,486,506,1611,447,1245,363;41;F
26965;576,1280,1591,242,1588,1168,1612,178,1545,1136,1421,1611,447,1245,363;70;M
27033;1626,1585,1311,1131,1421,1244,1280,1596,1545,1591,178,1612,1057,581,1245;16;F
27113;1280,1493,1563,486,1421,1265,1585,178,1128,1136,482,1131,1311,1545,1245;39;M
27181;178,363,1311,1671,1136,1576,1069,1561,1057,1135,242,1412,506,1590,1245;44;F
27206;1563,1594,482,1588,1139,1168,1311,178,1141,1002,1128;36;F
27285;726,482,1421,1265,1128,162,160,720,1131,1311,1545,1280,1136,506,1576;33;F
27323;720,1139,1131,1626,506;35;F
27374;1168,178,1002,1280,1421,506,1576,1588,1135,1311,1611;32;M
27448;1057,1612,1588,204,1356,1135,178,1280,1128,1625,1136,1421,506,1563,1245;26;F
27754;486,1563,1493,482,1588,1311,1585,1561,1671,1545,1002,1136,506,1611,1245;47;F
27825;1311,1545,1265,1590,506,1245;51;F
27855;1671,1412,506,1131,1128,1136;41;M
27857;115,581,1057,1545,162,1139,1311,1244,1136,1576,1493;35;F
27900;1611,506,576,1128,1280,178,1311,1135,242,1545,1421,1136,1563,1594,1245;48;F
27947;204,720,1131,1311,178,1280,1136,447,1576,482;46;F
27967;726,1131,1311,1671,1545,1057,1128,1563;42;M
28004;1356,1588,1168,1644,1382,1421,1353,1611;35;F
28087;1421,1588,1168,1131,1280,1128,1136,1576,720,1135,1311,1585,1545,1563,482;39;F
28388;1135,1311,1057,178,1591,1141,1644,1128,1353,486,506,1563,1245,1594,1576;39;F
28498;1412,480,242,1588,1135,1168,726,581,1612,1585,1421,1611,1245,1576,1069;48;F
28584;1611,482,1588,1168,1585,1644,486,1245,1069,363;40;F
28637;1591,1280,486,1611,363;46;F
28649;115,1588,1135,1131,1626,1245,1576,363,1493;37;F
28653;1135,1545,1245;17;F
28679;204,1139,1588,1135,1168,1612,1382,574,1421,1353,486,1611,1245,1576,363;31;F
28731;1311,1596,1625,1421,1585,178,1168,1588,1545,1002,1136,506,1611,1245,1576;37;F
28767;1545,1280,1245,1576,363,482;47;F
29141;720,581,1057,1002,1128,1563,1493,482,115,1131,1311,160,1136,1576;34;F
29225;1545,1069,574,363,1591,1382,1611,1594,482,1057,506,1576,1280,1421,1245;46;F
29259;204,720,1131,1311,160,178,1545,1412,1280,1265,1136;;M
29350;486,506,1135,204,242,1131,581,178,162,720,1588,1128,1611,1057,1626;45;F
29387;1139,480,1588,1135,178,1545,1412,1644,1382,1002,1421,1563,1611,1245,1069;34;F
29391;160,1139,480,178,1545,447,482,1644,1563,1594,1245;41;M
29452;1588,162,1280,1625,1421,1611;37;M
29577;1493,1576,447,576,1265,1002,178,720,1311,1585,1545,1128,1136,1563,482;62;F
29663;1545,1356,242,1588,178,1585,1136,1611,1245,1576;40;F
29806;1611,363,1421,178,1311,204,242,1135,1612,1280,1245;39;F
29841;178,1002,1265,1563,1611,447,204,1135,1545,1244,1493,1245;24;F
29886;204,242,1588,1168,178,1545,574,1128,1611,1245;41;F
29999;1585,1421,1563,447,1245,480,1131,1311,581,178,1545,1002,1128,1136,482;37;F
30283;576,1128,1280,1002,1545,178,204,1139,115,1245,1135,480,1626,447,1563;48;M
30286;1280,1625,1576,204,242,1545,1421,1069,1588,1612,1671,1611,1245,486,363;37;F
30382;1002,1136,1611,1576,115,1139,1311,1585,1493,720,1131,1128,1563,1245,482;27;M
30527;1024,1588,1311,581,1545,1069,482,1245,1421,1002,162,160,1553,1057,1168;50;F
30625;1128,1265,1421,447,1594,1024,581,1644,1280,1625,1136,486,1563,1576,482;67;F
30670;1585,1591,1128,1421,486,1563,1611,1245,1576,482,1141,506,1311,1168,1588;43;M
30742;160,1553,1057,1131,726,1168,115,1139,1311,162,1244;26;M
31016;1135,178,1545;44;F
31064;1563,447,1245,482,1588,1135,1131,1311,1057,1545,1002,1280,1421,1136,506;38;F
31423;482,1611,1594,1573,1588,480,204,1135,581,1057,178,1644,1596,1421,1563;20;F
31452;1280,1421,1141,1135,1311,1612,178,1585,1591,1545,486,506,1611,1245,363;45;F
31502;1139,1588,480,1135,178,162,1002,1421,1136,506,1563,1245,1594;51;F
31705;1588,1611,1545,1311,1353,1002,1280,1644,480,1128,1563;36;M
31738;480,1561,1671,1421,1353,1136,1611,1576;39;F
31768;1069,1244,1545,178,1311,506;44;F
31857;1545,1265,1644,1421,1611;38;M
31945;726,1545,1644,1280,1353,486,480,1473,581,160,1382,1611,1245,1576,1493;37;M
31956;1594,720,1131,1311,1585,1545,1128,1136,1563,1493,1135,1057,506,1245;22;F
31964;1245,482,480,1057,1421,1576;31;M
32084;1493;38;F
32107;204,720,1131,1311,160,178,1545,1412,1280,1265,1136;35;M
32117;1311,1280,1611,1576,480,1588,1168,1057,1545,1644,1128,1625,1421,1563,482;39;M
32155;1131,1585,1382,1265,1128,1136,482,720,1311,1057,1545,1412,1244,1421,1576;31;F
32345;480,1168,1311,1545,1644;48;F
32430;1588,242,1168,1612,178,1545,1644,1002,1611,1245,1594,1135,1057,1412,506;37;F
32726;1611,486,1493,720,482,480,1131,1311,1545,1644,1002,1280,1128,1136,1563;44;M
32740;1611,1576,1131,1311,1545,1002,1280,1128,1136;34;M
32776;720,1131,1585,1545,482,1128,1245;34;M
32880;1588,1311,1612,1545,1421,1136,1611;39;F
32943;1591,1588,1311,1576;48;M
33130;178,204,1588,1612,1585,1591,574,486,1611,482,363;39;F
33178;1168,160,1136,1280,115,720,1588,1139,1131,1473,1311,1002,1421,482,1493;40;M
33317;1545,1141,178,1057,1473,1139,115,162,1412,1644,1265,1590,506,1245,1069;53;F
33387;720,1139,1311,178,1585,162,1002,1128,1244,1563,482;31;M
33620;1131,1057,1545,1412,581,1168,1588,1135,1141,1245,506;43;F
33723;1353,1136,1563,1594,482,1493,204,1057,178,1591,1545,1644,1611,447,1245;36;M
33765;1002,1382,1596,1412,1141,1591,1612,1057,1588,1168,1311,1545,1421,486,1245;44;F
33919;1590,178,1612,1168,581,720,1245,115,242,1135,1057,1141,1671,1412,506;33;F
33921;1311,1612,1244,482,1493,1545,1141,1553,480,1588,1168,1057,1585,1002,1421;28;M
34015;1057,178,1002,1280,1128,1244,1265,1136,1626,1245,1576,482,1311,1545,1611;44;F
34049;1671,1311,1131,1135,1139,1588,115,1356,1057,1545,1412,576,1136,1353,1245;23;F
34056;1625,1265,1280,1382,1671,162,1553,581,1356,1131,1473,1311,1128,1590,1493;43;F
34097;1585,1644,1057,1139,1594,1563,1590,1128,1280,1382,162,178,1553,581,1311;45;M
34418;1139,726,1311,581,1644,1128,1421;60;M
34495;1671,1412,1421,1245,204,242,1588,1139,1168,1311,178,576,1625,1611,447;64;F
34501;1069,482,1588,1139,1168,1311,1585,1591,1141,1244,1265,1625,1421,1245,363;60;F
34583;1311,178,162,1596,1136,1626,1135,1131,581,1057,1545,1644,1421,1245,1573;23;F
34945;1136,1588,1311,1002,1421,1611,482;36;M
34998;178,1545,1002,1280,1136,1576;51;M
35078;726,1644,1588,1311;20;F
35217;204;34;F
35275;1412,1244,1265,1032,1611,1493,720,242,1473,1057,1545,1280,1136,1245,1576;35;F
35361;115,581,1057,160,162,1128,1245,1576,204,1135,178,1545,1412,1136,506;35;F
35378;1588,1493,1563,1421,1585,720,1128,726,1131,1136,482,1311,1545,1280,1576;35;F
35481;447,1245,1069,1588,1139,1057,178,1002;42;F
35666;115,1139,178,1545,1412,486,1032,1245,1576;34;M
35772;1168,1576,482,480,1131,1311,1057,1585,1545,1644,1280,1128,1136,506,1563;37;F
35794;581,482,1493,447,1032,1545,178,242,204;30;F
35811;1612,1591,1671,1545,1245,482,1353,486,363;34;F
35853;1135,178,1545,486,1245,363;35;M
35882;1128,1136,1245,482,204,242,1588,1139,1135,1057,178,1591,1671,1611,363;40;F
35887;1576,1421,1625,1002,1382,1588,1168;48;M
35899;1588,1382,1576,1139,1057,1002,1611,480,482,1168,1311,1644,1128,1421,1563;41;M
35946;1588,1168,1057,1671,1644,1382,1002,574,1128,1265,486,506,1611,1245,363;36;F
36213;115,204,1588,1139,1644,1596,363;37;F
36236;1591,1644,1596,1590,1561,1594,204,1139,1612,1141,1128,1245;14;M
36250;1561,1545,1644,178,1057,581,1311,1131,1168,1135,1139,1356,204,1382,1353;23;F
36310;1612,1421,1588,1057,178,1671,1545,1412,1644,1265,447,1136,1590,1245,506;53;F
36313;1588,1611,447,1245,1576,363;38;F
36399;1141,1280,1265,506,1576,1573,1311,178,1545,1644,1128,576,1136,1563,447;63;M
36457;178;61;M
36747;1588,1168,1585,1002,574,1128,1421,1626,1563,1611,482,581,1057,1644,506;54;F
36753;178,1382,1002,1128,1625,1626,363,1139,1168,1311,1585,1545,1421,1611,1245;45;M
36870;1590,1588,242,720,1136,506,1563,1611,447,1245,1594,1576,1069,1573,363;62;F
36893;1135,1141,1265,1590,506,1493;30;F
36995;506;61;F
37109;1128,1245,1576,1588,1168,1311,1382,1625,1611;48;M
37184;204,1421,486,1493,720,178,1671,1412,1002,1265,1590,506,1611,1245,1069;38;F
37219;506,1594,1576,1069,1245,1644,1545,581,1135,204,242,178,576,447,1573;53;F
37260;1069,1611,1590,1644,1141,1473,1265,506;32;M
37439;1612,162,1002,1280,1136,486,1563,482,115,1588,1168,1585,1421,1245,1576;45;F
37481;506,1493;31;F
37500;1625,1626,1032,1245,1594,1573,204,581,1057,178,1671,1545,1280,574,1135;29;F
37503;115,204,1131,1311,178,1585,1545,1644,1128,576,1625,1136,447,363;43;F
37566;1585,1421,1136,1032,1611,1576,482;19;M
37654;242,480,1131,1311,1057,178,1644,1128,1421,1032,1245,115,1265,1590,506;47;F
37727;1644,1002,1245,581,178,1591,1596,447,363,1139,1588,1421,1611,1576,482;35;M
37760;1057,178,162,1644,1280,1128,1265,1421,1032,1590,506,1245,1594,1576,482;46;M
37792;160,720,1588,1139,1168,162,1563,242,1612,482,1545,1280,486,447,363;40;F
37818;480,1311,581,1057,1553,1591,1545,1644,1128,1421,1136,1245,1594;21;F
37839;204,447,486,1625,1421,1128,1588,1311,1135,178,1545,1280,1136,1611,1576;70;F
37840;115,480,1135,1311,1561,162,1576,1245,1421,574,1139,1141,1644;24;F
37855;1280,1136,1245,482,480,1139,1168,1311,1057,178,1128,1421,1576,506,1594;21;F
37872;480,1588,1168,160,1585,1545,162,1421,1563,1576,363;50;F
37877;1611,1563,1002,1588,1024,160,1585,178,1545,162,1128,1421,1576,1594,1493;49;M
37883;178,1412,1596,1563,363,1588,1135,581,1057,1553,1545,1421,1626,1245,1576;35;F
37923;1069,1588,1024,1168,486,363;55;F
37925;204,242,1131,1168,1057,178,1244,1265,576,1421,1032,1590,506,447,1245;55;F
37953;1128,1265,1421,1611,482,1493,1168,1131,1311,1057,160,1671,1545,1412,1244;29;M
37971;1135,1585,1002,1128,1563,1493,1131,1311,1553,1545,1280,1421,1136,1245,482;19;F
38005;726,720,1135,1057,1002,1421,1136,1245,1576,1588,1131,1311,1585,1545,1280;43;F
38042;1588,1139,1585,1136,1626,1245,1644,1057,581;42;M
38059;1545,1280,1002,1421,1563,1611;30;F
38090;1573,1493,720,1473,178,162,1128,1625;58;F
38150;1545,1168,1588,480,1135,1311,1612,162,1280,1421,1136,447,1245,1576,482;18;F
38154;1245,574,1280,1382,1585,1057,1588,1139,1131,1128,1573,482,1493,720,1311;29;M
38210;204,242,1356,1588,1135,1057,178,1561,1671,574,576,1353,1563,1611,1493;33;F
38326;1002,1573,482,1136,1421,1280,162,1545,178,1311,1135,1588,480,1590,1576;28;F
38509;1245,1311,1588,480,1168,178,1585,1545,1002,1280,1421,1353,1563,1611,447;38;M
38511;1356,1131,1057,160,1561,1545,1644,1128,1265,1421,1353,506,1611,1245,1069;31;F
38576;1671,1412,1135,581,1057,178,1545,1280,576,1625,1136,506,447,1245,1069;45;F
38870;1131,1588,1311,1057,1553,178,1644,1002,1280,574,1128,506,1611,447,1245;44;F
39101;1591,1545,1382,1421,1136,1611,1594,1069,482,1168,1057,162,1644,1128,1244;36;F
39113;1591,1545,1128,486,1590,1563,1611,1594,1069,1135,1644,1136,1032,506,1245;28;M
39310;204,720,242,1135,1131,1311,178,1585,1545,1412,576,447;52;F
39404;480,1135,1545,1136,1563,1421;30;F
39445;486,1493,482,1611,1563,1128,1280,1545,1585,160,720,1588,1311,1136,1131;35;M
39446;482,1245,1139,1473,1057,1141,726,162;30;M
39508;1412,242,1002,1311,1591,1626,1057,1141,1545,204,1644,1128,506,178,1563;44;M
39518;115,363,482,1493,1131,1545,162,1382,1280,1128,1244,1136,486,1590,1576;33;M
39577;1168,1311,204,480,242,178,1545,162,574,1136,1563,1611,447,1245,1576;38;F
39627;506,1573,482,1493,1473,1131,726,1139,720,178,1545,162,1136,447,1245;31;F
39650;204,480,242,1168,1311,178,1545,162,574,1136,1563,1611,447,1245,1576;7;M
39669;1585,1545,1128,1563,1576,482,1139,1135,1131,1311,1057,162,1644,1245;29;F
39696;1493,1563,1265,1244,1128,1280,1585,1612,1311,1131,1553,1545,1136,1421,1625;31;F
39722;1311,1057,1141,1545,1136,486,1245,1265,506,1131;32;M
39767;480,1168,1576;40;M
39882;1311,1412,576,1421,1032,1590,447,1245,1576,1135,720,1131,178,1545,1136;55;F
40020;720,1625;62;M
40074;1139,720,1588,1168,1311,1591,363,1128,1611;44;F
40087;1135,1139,1553,178,1128,1563,1588,1131,1311,1057,1545,1644,1136,1576,482;25;F
40175;1596,1545,1057,1311,1135,1421,1032,1245;20;F
40232;1412,1644,1002,1128,576,486,1611,447,1576,482,1588,1057,1585,1280,1136;43;M
40331;1311,1168,1588,1585,1611;40;F
40390;1131,1588,1356,1311,1421,1032,1245,1576,363,482,1611,1563,1382,1596,204;24;M
40515;1612,204,1588,1131,1311,1057,1412,1280,1128,1421,1353,1136,506,447,1245;37;F
40674;1244,1421,486,1032,1563,1576,363,115,480,178,162,1382,1280,1128,482;33;M
40680;115,1131,1168,1024,1139,447,1576,1069,1493,1135,1545,1244,1265,1590,1245;46;M
40879;506;66;F
40881;506;65;F
41208;115,1139,1135,1493;50;F
41213;1139,1168,160,1136,1245,1493,162,1244;38;M
41288;1168,1473,1311,1591,1002,1421,1136,506,1563,1576,1588,1585,1545,1611,1245;40;F
41600;204,1139,581,1057,178,1545,1412,1644,1596,574,1032,1590,506,447,1245;86;F
41727;1563,1611,482,1493,1588,1139,1135,1131,1311,1057,1545,1644,1002,1128,1245;41;M
41798;1069,1136,1280,162,1141,581,1139,720,1135,1265,506,1245;34;F
41809;1553,1671,1596,574,1128,363,1245,1626,1421,1265,178,1612,1139,506,115;32;M
41831;1245,1644,1135,1057,178;22;F
41908;1135,1311,1057,1545,1002,1280,1136,506,1594;32;F
41929;1139,1588,204,480,242,1311,1057,1644,1128,1245,1576,482;41;F
41937;1591,1141,1644,1625,1032,1139,1671,1265,506,1590,1412,1057,720;45;F
42049;162,1625,1421,1353,1626,1311,1128,1265,1563,1611,1245,1594,1576,1573,1493;18;F
42053;720,1576,482,1128,1644,162,1545,160,1311,1139,115,726,1131,1421,1136;37;F
42132;480,115,1057,1131,1588,1311,1545,1644,1280,1625,1421,1136,486,1611,1576;80;M
42194;576,115,720,1139,1135,1545,1493;44;F
42235;720,115,1139,1057,1553,162,576;43;M
42531;1136,1421,162,1545,1057,1131;64;M
42568;1135,1473,1311,178,576,1069,115,1644,1493;27;M
42582;447,115,1135,1644,1473,1311,178,1069,1493;27;F
42747;1356,581,1057,160,1412,1644,1625,482,1353;38;F
42928;1057,178,1545,1280,1136,506;23;F
42933;1135,1168,178,1002,1280,1128,486,506,1594,1576,482,1311,1545,1421,1245;45;F
42939;1421,1473,1311,1141,1545,1611,1135,1131,1057,178,1591,1590,506,1245,1069;44;F
43000;1128,1493,115,726,1311,1136,1576,1421,1139,1588,1563,160,162,720,1131;29;F
43089;1594,1168,1588,242,480,720,1057,1545,1280,1421,1611,1245,1576,363,482;44;F
43172;204,178,1421,1611,1245,1576,482;38;F
43205;1311,1131,1136;41;M
43251;1141,482,480,1311,178,1545,1002,1280,1128,1421,1576,1136,506,1563,1611;55;F
43314;1024,1168,1057,178,1545,1280,1128,1625,1421,1136,506,1563,447,1245,1594;56;F
43358;1671,162,1244,1069,1421,1382,1412,581,1135,242,1057,1002,506,1245,1594;59;F
43369;1311,1057,1671,162,1644,1265,1136,1032,506,1611,1245,1131,178,1412,1590;40;F
43397;160,1473,1131,726,1168,480,1588,1311,1585,1545,1002,1128,1136,1611,482;47;M
43506;1421,1353,1136,486,1245,1576,482,1356,1588,1135,1585,1591,1128,1265,1611;36;F
43521;115,1473,720,1553,1493;28;M
43522;1356,1139,1412,1057,1280,1032,506;54;M
43552;1356,1412,1057,1280,1032,506;40;F
43583;1356,1412,1057,1280,1032,506;8;M
43637;1128,1245,1069,482,480,1356,1588,1311,581,1057,1141,1644,506,1611;40;F
43662;480,1588,1644,1382,1128,1245,1594,1576;69;F
43699;1139,1265,482,480,1612,1412,1644,1280,1421,1136,1563,1611,1245;38;F
43789;115,1139,1135,178,1545,1412,1596,1265,1421,1136,486,1590,506,1245,1069;48;F
43943;1311,178,1412,1280,1353,1135,1131,160,1545,1265,1421,1136,1626,1245,1493;39;F
43947;447,1421,178,1311,1139,115,726,1612,1644,1245,1576,1168,506,486,363;42;F
44057;204,1139,1311,581,1057,178,1545,1412,1644,1596,576,1625,1421,447,1245;54;F
44088;1561,506,1245;35;F
44135;1057,1612,1561,1671,1128,1421,486,506,1245,1576,115,1131,1545,1412,1136;37;M
44168;204,178,1596,1382,574,1421,1611;37;M
44263;1069,1590,506;69;F
44475;242,1561,1671;41;F
44476;1591,1280,1136,1576,486,363;55;F
44500;1136,1563,1611,1245,482,115,1588,1135,1168,1131,1311,1545,486,1576,363;28;F
44674;1057,1280,1590,506,1069,1493;40;F
44869;1265,204,242,1057,574,115,1493,178,1412,1644,576,1421,1032,1576,1573;38;F
44893;1576,1032,1412,1612,1057,242,1135,1311,178,1136,506,363,1545,1590,1245;49;F
44908;720,1131,1311,1585,1545,1412,1596,1002,1265,1136,1563,1611,1245,482,1493;33;M
44933;178,1057,1473,1139,242,480,204,1611,1576,1573,162,1280,1131,720,1311;26;F
45202;1588,1612,178,1421,486,506,1611,363;39;F
45225;1421,1136,1611,115,1588,1139,1168;68;M
45233;115,720,1139,1473,574,1244,506,1611,1245,363;33;F
45249;1265,506;62;F
45278;486,363;11;F
45299;1135,486,363;8;M
45305;480,1168,1057,178,1141,1545,1644,1128,1265,1421,506,1563,1594,1576,1069;47;F
45342;1356,1311,1561,1280,1421,506,1069,1135,178,1545,1382,1136,1245,363,1493;28;F
45351;486,363;36;F
45407;1612,1421,574,1280,1545,178,1311,1168,204,1128,1626,1563,1611,1594,482;41;F
45423;204,480,1168,1131,178,162,1265,1421;56;F
45431;1545,1644,1280,1493,115,1141,1265;49;F
45447;1591,1168,242,1588,1057,1612,178,1644,1596,1002,574,1421,486,1611,363;40;F
45520;1139,1135,726,1311,1545,1280,1136,1245,1594,1576,1069,482;23;F
45524;178,1131,1612,1576,1245,1136,1421,1002,1311,1588,1168,1280,486,1611,363;36;F
45559;1136,1626,1245,1069,363,204,1588,1139,1135,1612,178,1644,1596,1002,1611;41;F
45571;1135,1057,1545,1265,1590,1069;46;F
45775;1611,1594,1493,482,115,204,720,1473,1311,1135,1139,1545,162,1141,1563;46;F
45801;480,1588,726,1168;36;F
45802;1136,204,576,1032,506,1057,178,1671,1545,1412,1421;42;F
45921;726,1311,1421,486,1626,1245,1576,482,115,480,1139,1131,1545,1280,1136;28;F
45936;1139,1131,1311,1057,1545,162,1412,1136;34;M
45967;1280,1136,1245,1576,1588,204,1612,1585,178,1141,1591,506,1594,363;44;F
45975;242,1135,1057,178,1141,1671,1412,1265,1353,1136,506,1611,1245,1573,1493;34;F
45979;1265,1421,506;64;F
46030;574,1644,162,1135,1576,115,720,242,1139,1473,1311,178,1412,576,1493;41;F
46032;576,1563,1611,447,486,1136,1591,1168,1135,1139,1057,1545,1280,506,1588;42;M
46060;1128,1671,1141,1591,1024,1588,480,1057,1644,1069,506;51;F
46114;1585,1421,1139,1131,160,1002,482,1136,1563,1493,480,1311,1545,1128,1576;33;M
46194;1057,1545,1382,1002,1265,1625,506,1563,1245,1594,1576;62;F
46213;162,1135,1311,1002,1421,1382,1128,1245,1563,1168,1545,1280,1585,1611,1139;30;F
46266;242,1588,1311,1612,1585,1545,486,1611,1245,1576,363;31;F
46322;1588,1280,1421,1611,1576,1311,1245;35;F
46364;1168;14;F
46392;1244,1131,1311,1585,1545,1002,1280,1128,1136,1563,482;35;M
46443;1625,1421,1245,1311,178,1591,1545,1644,1563,1594;41;M
46477;178,1141,1545,1128,1244,1625,1594,1069,1576,363,1135,1057,1644,1245,482;46;F
46516;160,1591,1561,1545,1644,1128,1136,480,1139,1311,162,1280,1421,1594,482;38;M
46527;1168,482,1576,1245,1611,1563,1136,1421,1280,1002,1545,1591,178,1311,1588;16;F
46611;115,720,1131,1585,1545,1382,1563,1493;45;M
46778;1141,1057,720,726,160,178,1585,162,1644,1002,1421,1626,1563,1245;21;M
46793;1131;25;F
46869;1591,1588,1135,1168,1644,1002,1280,1128,1625,1421,506,1576,1069;45;F
46915;720,1421,1245,1576,482,1493,1136,1244,1588,1135,1168,1311,160,1545,162;41;F
46917;1131,1412,1644,486,1002,1611,1493;35;F
46923;1563,1611,363,482,1493,1128,1280,1002,1057,1311,1131,204,1545,1136,1245;48;F
46948;720,482,1245,1002,1644,581,1311,480,242,1588,178,1545,1421,1611,447;58;F
47007;720,726,1131,160,1585,1545,1002,1128,1136,1576;24;M
47057;1057,480,1671,1412,1644,1280,1611,1245,1421,486,506,1563,1594,1576,1069;39;F
47187;720,1139,581,1057,1591,1141,1280,1265,1421,486,1032,1590,506,1245,1069;41;F
47191;1421,506,447,1245,1069,1573,204,1139,1135,1311,178,1596,1626,1032,1590;45;F
47250;1561,1612,581,1131,1135,1139,1311,1057,178,1671,162,1545,1412,506,1245;47;F
47627;1421,1311,480,162,506,1563,1141,178,1131,720,1545,1136,482,1245,1594;27;F
47708;1612,178,1141,1545,1644,1002,1280,1265,1421,1136,1563,1611,1245,1594,1576;42;M
47776;1032,506,1563,1611,1576,1594,1069,1573,363,482,1493,1131,1311,1057,1245;23;M
47790;482,1493,204,726,1131,178,1245,1576,720,1311,1057,1545,1280,1421,1136;26;F
47805;178,1131,1311,160,1353,1611,1576;35;F
47824;1588,1553,160,1585,1280,1136,581,1057,1596,1245;28;M
47919;178,160,1311,726,1168,1135,242,480,1588,1644,1563,1611,1245,1576,482;41;F
48027;480,1588,1168,1311,1002,1594,447,581,1057,1644;64;F
48091;242,1356,1588,1135,1561,1412,1644,1382,1280,1353,506,1611,447,1245,1576;36;F
48216;1671,1545,1644,1280,1128,1265,486,1588,1311,1141,1421,506,1611,447,1245;42;F
48308;1493,1311,1139,1135,1131,1057,1141,1545,162,1644,1265,486,506,1245,1069;47;F
48361;447,1594,1576,1545,204,1024,1311,1057,178,1596,574,1128,1563,482,1245;53;M
48545;1032,720,1139,1135,1280,1473,1311,1057,178,1545,1412,1590,506,1245,1576;24;F
48593;1139,1135,1131,1545,1596,1280,1128,1421,1136;35;F
48676;1594,1611,1421,204,1588,1139,726,160,178,1591,447;45;F
48809;1032,720,480,115,1545,1128,482,1412;47;M
49033;1596,1311,1545,1412,1032,1280,1136,1590,506;31;M
49199;1136,1131;43;M
49226;1128,1136,363,1576,486,1412,1545,178,1057,1131,1135,1139,1588,204,720;44;M
49230;178,1561,1644,1421,1611,447,1594;36;M
49299;1563,581,1553,1585,1131,1311,178,1545,1002,1280,1128,1136,1245,482,1493;50;M
49336;581,1545,1128,1136,506,1493;22;M
49379;1311,204,480,1588,1644,1596,1280,574,1265,1421,1136,1353,1245,1576,482;32;F
49404;1131,1585,1644,1382,1128,1421,1563,1611,1576,482,726,1311,1057,160,486;35;M
49431;1265,1625,1311,1545,1128,1244,1032,1136,1576,1131,1553,1057,1590,1671,1412;50;M
49627;1135,1057,160,178,1644,1280,1265,576,506,447,1245,1069,1573,482,1493;60;F
49682;1311,160,482,1421;32;F
49791;1421,1311,1545,162,726,160;29;F
49812;1588,1612,178,1545,1421,1136,1563,447,1594,1576,363,482;39;M
49820;1057,1265,1128,1136,506,1245,1576,1135,726,1311,160,1545,162,1421,482;31;F
49828;1545,1280,1128,576,1136,1563,1245,1576,1493,480,726,1131,1057,160,178;33;F
49833;1590,1069,1131,581,1553,1128,1545,1585,1311,1265,1002,115,720,506,1493;31;F
49861;1139,1473;47;F
49868;1612,1644,1382,1168;31;M
49919;204,1139,162,726,160,1545,1280,1136;29;F
49926;1131,1311,1057,1545,1136;70;F
49953;486,1311,480,204,1135,576,1280,1421,1136,447,1576,482,1545,1168,1245;49;F
49955;1588,1168,1382,1421;47;M
50004;204,1139,1168,178,1563,1611,447,1245;39;F
50109;1128,1545,1612,1168,720,480,1588,726,1131,1311,1057,160,162,1245,1576;25;F
50162;1473,1168,1493,1576,1128,1002,1057,1311,720,480,726,160,162,1421,482;42;F
50167;1057,1311,1131,1168,1135,720,1585,1644,574,1136,486,1563,1245,482,1553;34;F
50188;1311,1612,1591,1141,1545,1421,1136,1594,1576,1588,1168,1002,1382,1611,1069;41;F
50200;720,1135,1057,160,1644,1280,1265,576,506,447,1245,1069,1573,482,1493;67;M
50242;1545,1612,581,1131,1139,1280,1244,576,1625,1136,447,1265,1563,1590,506;44;M
50267;1168;38;F
50280;581,1139,115,204,1057,178,1561,1671,1412,1644,506,1611,1576,1573,363;43;M
50307;720,204,1139,1131,1591,178,1545,1596,574,1128,1265,486,1032,1590,1245;28;M
50428;1168;43;F
50487;726,1311,160,162,1421,1576;26;F
50533;1671,1563,1493,1473,1135,1139,1576,1069,115,1057,1412,1032;29;F
50584;204,1588,726,1311,1057,160,178,1644,1421,506,1576,1611;34;F
50632;1671,1591,1311,726,1168,1139,1588,115,1128,1265,506,1576,482,1611;25;M
50708;242,480,1612,178,1545,162,1280,576,486,1421,1563,1594,482,363;38;F
50719;1588,1356,480,1135,1553,1612,1644,1002,1280,1128,1421,506,1563,1245,482;33;M
50772;1141,1644,506,1563;33;F
50807;1245,1057,1644,1421,1563,506;40;F
50874;1057,178,1591,1545,162,1644,1002,1244,1625,1421,1493,1588,1280,1265,1136;31;F
50929;1244,1245,160,1421,1136,1069;20;F
51150;242,1591,1412,1353,1590,1594,576,447,574,204,178;33;F
51266;204,480,242,1356,1141,1561,1412,1644,1596,574,1265,1421,1353,506;38;M
51276;1135,204,242,1588,1139,1168,1057,178,162,1412,1382,1563,1611,1245,363;56;F
51413;720,1135,1311,160,1545,1002,1280,1421,1136,1563,447,1245,1576,1493,482;24;F
51506;1588,1139,1311,1585,1002,1563,1611,1245;29;F
51592;1141,1545,1644,1382,1280,1265,1421,1136,506,1563,1611,1245,1594,1576,1069;32;F
51688;1612,1311,204,1139,726,178,160;60;F
51728;1553,1545,1245,482,1493,1311,1612,1002,1128,1421,1136,1139,1131,486,1069;42;M
51765;363,486,480,1588,160,1591,162,1590,506,1563,1576,1493,1421,1245,1594;25;M
51796;1356,1585,1561,486,506,1069,204,242,178,1412,1353,1141,1611;31;F
51799;1136,1421,1265,1128,574,1545,178,1311,242,204,1576,1057,1002,486,1245;39;F
51839;1168,162,482,1311,581,1421,1136,1545,1141,1057,1563,1594,506,480,1644;32;M
51880;1245,115,1421,1139,1545,1353,486,1032,506,1611,1576,204,1131,1136,1356;31;F
51893;1168;50;F
51988;1131;36;F
52012;1311,482,1136,1168,1002,1141,1545,1057,162,1421,1594,480,1563,1644,506;31;F
52071;204,480,1588,1139,178,1545,1644,1596,1353,1136,1563,447,1611,1245,363;41;M
52101;1588,1024,1311,1553,178,1002,1280,1421,1611,363,482;64;M
52142;1588,1135,581,1057,1561,1412,1421,1168,506,1563,242,1594,1069,480,1644;38;F
52213;1131,1280,1128,1265,576,1136,486,1245,1594,363;28;F
52215;1576,1671,1553,1311,1168,1135,1139,204,1588,506,1563,1611,447,1245,482;42;F
52350;581,1561,574,1280,1128,1136,1356,1135,178,1545,1644,506,447,1245,482;50;F
52351;1594,1473,506;35;F
52358;1644,1382,1139,1168,1311,1057,1545,1002,1280,1128,1136,1563,1611,1576,482;53;F
52425;1611,486,1128,162,1585,1311,726,480,720,1135,1131,1057,1265,1421,1576;38;F
52553;1563,1421,1168,115,1588,1139,1311,1057,178,1545,1002,1280,1625,1136,506;48;F
52677;1611,1128,1412,1591,178,1612,1057,1168,1563,1588,1311,1585,1545,486,482;36;M
52713;1412,1002,576,1421,1245,482,204,1588,1139,1135,1591,1141,506,1611,1594;41;F
52851;1168;49;F
52856;162,1421;32;F
52929;1311,1057,1612,1561,1671,162,1412,1244,1265,1590,506,1245,1576,482,1493;39;F
53124;1545,1671,1141,1591,1139,1311,1057,178,1576,1644,1002,1280,1128,1421,506;32;F
53298;1139,162,115,1128,1265,1136,506;61;M
53447;1032,178,1545,1280,506,1563,1611,1576,480,1588,1135,1168,1644,1245,1421;38;F
53464;242,1412;36;M
53521;1139,115,162,1128,1265,506;65;F
53561;1128,720,1421,1588,1002,1576,482,1136,1131,1280,1585,1493,1563,1545,1311;39;M
53675;1280,482,1588,1311,1545,1421,1245;46;M
53677;480,178,1135,1311,1141,1545,1280,1421,1136,506,447,1245;44;F
53708;242,1356,1588,1139,1135,1168,1311,178,1561,1671,1545,1644,1136,1611;41;F
53709;1353,1563,1611,1573,482,1493,204,720,115,1311,1057,1585,1412,1032,1576;29;F
53767;1311,1168,1591,1545,1002,1245,1576,242,1588,1135,178,1644,1382,506,1611;36;F
53852;1002,178,726,1473,1139,1563,1611,1576,482,720,1588,1131,1128,1421,1493;32;M
53862;1002,574,576,1136,506,1594,1069,363,482,1588,178,1280,1421,1611,1493;39;F
53894;1644,242,1135,1588,1168,1612,178,1591,1545,1280,1136,486,506,1611,1245;36;M
54031;1612,1168,1135,242,1588,1545,1671,1412,1002,1421,506,1611,1245,1576,1069;36;F
54075;1611,1553,1002;68;F
54093;162,1585,160,1135,1024,1139,204,1588,1168,1311,1002,1421,1136,1563,1611;39;F
54168;1139,178,1412,1644,1421,1353,1136,1245,1594,1576;31;M
54191;1588,1139,178,1545,1611,1245,1576;37;F
54430;363,480,1131,1311,1545,1002,1280,1421,1136,1590,506,1563,1611,1245,1493;35;M
54638;204,242,1588,1131,1311,1057,1545,178,1585,1611,447,1245;34;F
54816;1168,1139,1135,1311,1057,1553,178,1545,1644,1596,1002,1280,1128,506,1245;44;M
54876;1421,160,726;31;M
54987;1245,1625,1545,1561,1356,242,204,1612,178,1591,1671,1412,1353,486,363;39;F
55027;1588,1139,1612,178,1591,1671,1412,1421,1353,486,1626,1611,1576,1069,363;41;M
55036;480,1588,1139,1024,1311,1057,1644,1002,574,1611,1576,482;71;F
55057;204,242,1588,1139,1612,178,1591,1671,1128,1353,486,1626,1611,1576,363;12;M
55064;115,1057,1545,1002,1128,1244,1136,1576,1069,482,726,1311,1421,160,162;28;F
55162;480,242,1311,1612,1412,1644,1280,1128,1421,1136,1245,482,1545,506,1563;40;F
55198;581,1131,1588,1139,1311,1057,1671,1545;66;F
55209;1069,447,506,1032,1421,576,1265,1141,178,1612,1311,1139,115;60;F
55238;1588,720,1135,726,1131,1311,1057,1545,162,1280,1136,1032,506,1245,1576;33;F
55254;1280,576,447,1245,204,242,1588,1311,178,1591,1644,1002,1265,506,1611;36;F
55309;480,726,1311,581,1057,178,1545,162,1245,1594,1576,482;42;M
55318;1245,1545,1244,1032,720,726,1057,160,162,1265,1421,1136,1563,482,1493;33;F
55344;486,1611,1245,1576,363,482,1139,1168,1057,1585,1591,1545,1128,1625,1626;42;F
55378;720,480,1139,1585,1493,1563,1136,1545,160,1311,1131,726,1421,482;36;M
55382;1139,1057,1141,576,1590,506,1573,1493;56;M
55406;720,1057,1412,1421;38;M
55417;1563;38;M
55442;1576,363,115,480,1024,1139,1168,726,1473,581,1553,162,1596,1245,1493;21;M
55586;1280,1588;26;M
55592;242,1576,506,1311,1135,204,1168,178,1545,1280,1421,1136,1611,1245,1069;36;F
55650;178,1412,1245,1057;40;F
55660;482,1576,1421,480,1139,1644,1128,1563,1245;24;M
55690;480,1588,1139,1131,1311,1057,1545,1644,1128,1353,1626,1563,1611,1245,482;36;F
55740;720,1139,1135,1131,1311,581,1545,447,1245,1576;19;F
55783;1131;56;M
55801;480,1588,1168,178,1585,1280,1136,1611,1245,1576;35;F
55809;1002,1561,1057,1139,1588,1168,1311,1545,1644,1382,1280,506,1611,1069,1245;60;F
55884;1591,1168,480,1588,1135,1311,1545,1002,1280,1421,1611,1245,1576,482,1493;26;F
55911;1135,178,1585,1626,1576,1611,115,1588,1131,1545,1136,1245,482,1563,1311;61;M
55947;1311,1588,1545,1382,1421,1576,482,1002;29;M
55994;1596,1545,1135,1032,1265,1057,506,178;59;F
56296;1421,1588;57;M
56325;115,720,1057,1671,1545,162,1412,1644,1280,1136,1576;33;M
56331;1128,1644,720,480,1131,1311,1057,1545,1596,1002,1280,1421,1136,1563,482;28;F
56352;1135,581,1057,160,1265,1136,1590,506;35;F
56404;162,178,160,1131,720,242,1311,1545,1412,1136,1245,1594,1069,482,1493;66;F
56630;115,1473,1057,1671,162,1644,1421,1032,1493;26;M
56638;1141,581,720,1057,1671;35;F
56652;1168,1311,1280,1421,1136,1563,1245,1594,482;66;F
56682;1588,1168;34;M
56950;1135,1024,720,160,1588,1168,1545,162,1596,1280,1128,1136,1611,1245,482;43;M
57150;1265,1545,1311,178,1128,1136,1563;54;M
57186;1611;32;F
57217;1644,1412,1545,1671,480,242,1356,1588,1168,1057,1311,204,178;43;F
57236;1141,1591,1135,581,1057,1612,178,1644,574,1625,1136,506,1611,447,1245;47;F
57281;1563,1585,115,480,720,1139,726,1131,1311,1591,1545,1421,1590,1594,1576;36;M
57301;1591,1280,1585,1576,1588,1545,1421,1136,486,447,1594,1563,1245,482,1611;43;F
57390;482,480,1139,1311,1545,1644,1280,1128,1421,1136,486,1563;27;M
57409;1421,1545,1311,115,1493;45;F
57419;1421,1545,1591,1553,1588,1131,1311,1057,1612,1141,162,1412,1644,506,1245;28;M
57506;1545,1576,1069,178,242,1131,1057,1561,1412,1128,1265,576,1353,1032,1590;32;F
57538;1591,1280,1128,1244,1421,486,1626,1563,1245,1594,363,482,1265,204,1588;47;F
57609;178,1585,1382,1128,1576,363,204,1588;49;M
57696;1493,1057;37;M
57711;160,178,1585,1591,162,1002,1128,1421,1245,1594,447,1611,1563,1576,363;15;F
57878;363,482,1493,1473,1168,1131,1311,160,1382,1588,720,1002,1421,1563,1611;39;F
57998;1588,1135,1168,160,1553,1612,1265,1611,1131,1545,1412,1421,1136,1245,1576;32;F
58037;1311,242,204,115,1244,1353,1032,1245,1591,178,1057,1139,1356;37;F
58052;1168,1135,1139,480,1057,1545,1644,1280,1421,506,1563,1245,1594,1576,482;33;F
58057;1141,178,1612,1057,1311,1139,1588,1591,1136,482,1611,1245,1594,1576,1069;26;M
58197;1644,1625,1136,1032,115,720,1139,1576;28;F
58259;480,1057,1644,1563,1493;50;F
58281;1311,1382,726,160,162,1128,1353,1245,482,1588,1139,1545,1421,1136,1576;35;M
58417;1139,1545,1128,1136,1563,1245,1493;36;F
58476;1421,1563,1245,1591,178,1311,204,1588,1168,1057,1545,1136,486,1611,363;45;M
58570;1136,720,1135,726,1311,1057,162,1644,1280,1353,1590,506,1563,1245,1594;21;F
58638;480,1588,1168,1311,581,1057,1585,1591,1141,1545,162,1644,1245,1576,1069;32;F
58679;1545,1421,486,1245,1493,1576;28;F
58707;1168,160,1612,178,1591,1545,486,447,1576,204;37;F
58751;1131,204,480,242,1139,1135,581,1057,1612,178,1545,1644,1002,1611,1245;32;F
58901;1591,1382,1280,1128,1625,486,1576,1588,1545,1136,1611,1245;46;F
58942;1563,1032,486,1136,1128,162,1591,1585,1139,720,726,1311,160,1545,1576;28;M
58983;1128,162,1545,178,1473,726,1139,480,1131,1311,160,486,1136,506,1245;42;F
59007;1128,1244,1136,1590;32;F
59114;1588,242,204,447,1244,1002,1280,1596,1545,160,1024,1168;51;M
59192;480,1588,1168,1421,1245,1576,1493;42;F
59304;1576,480,1588,1135,1131,1311,1585,1545,1412,1002,1128,1563,1611,1245,482;44;F
59392;1591,178,1311,1168,1139,480,1563,486,1421,1131,1135,1057,1585,1644,1626;45;M
59450;1585,1644,1280,1421,486,1245,1594,1069,1139,1135,178,1545,162,1136,1576;32;F
59454;115,1131,1311,1585,1545,162,1280,1128,1421,1136,486,1611,1245,1576,363;27;F
59527;1135,1591,1545,1594,726,1131,1311,160,178,162,1128,1136,447,1245,1576;43;M
59607;204,1311,581,1057,178,1545,1644,1128,1244,486,447,1594,1576,482;23;F
59616;1128,1265,506,1069,1588,1057,1545,1644,1421,1136,1611,1245,1576,482,1493;28;F
59637;720,178,1545,1245;40;F
59664;506,1611,1594,1069,1573,482,720,1473,1311,1612,1128,1265,1032,1590,1493;42;F
59670;482,1136,1545,1057,726,1588,480,1493,720,1553,1131,1311,1576,160,162;27;M
59848;1135,1057,1612,1545,162,1644,1265,1245;48;F
59925;1356,1135,1311,1671,1382,1002,1128,1244,1421,1032,506,1611,1245,1576,482;39;F
60096;115,1139,1473,1311,178,1545,1644,1280,576,1136,1626,447,1245,1576,1493;46;F
60121;1611,574,1591,1131,204,1057,178,1545,1412,1644,1280,1136,506,1245,1594;54;M
60172;482,1311,1131,1139,242,115,204,1057,1612,178,1545,1280,1136,1032,506;34;M
60200;581,1311,1168,1135,1139,1588,1356,115,1057,1591,1644,1421,1611,1245,482;32;F
60260;1553,1585,1625,486,1611,447,482,204,480,178,1644,1280,574,1421,1563;41;F
60309;482,1245,1128,162,1131;33;F
60404;1069,1265,1136,506,1245,1576,1311,1545,1128,1244;55;F
60516;1131,1311,1545,1136,1493;26;M
60531;726,1168,480,115,160,178,1585,162,1382,1002,1244,1625,1032,1493,1576;40;M
60544;242,1588,1168,1311,1585,1591,1002,1421,1576,1611;38;F
60721;1131,1644,1576,1135,1057,178,1421,1245,1069;28;F
60921;506,447,1553,1585,1002,1421,1136,482,480,1057,1591,1644,1563,1245,1594;32;M
60937;1131,1168,1588,1596,204,581,1057,1493,1644,1069,1594,1591,506,1139,1135;41;F
60988;1588,1245,1576,363,1135,1141,1561,506,1611,1644,1139,1131,1591,1626,1069;45;F
61021;1311,1128,1576,1588,1585,1168;43;M
61118;1585,581,1168,1353,1611,1625,242,1588,1311,1057,1002,1421,486;69;M
61169;1280,1136,1311,1545;30;F
61236;1353,115,204,242,1057,160,1612,178,1545,1412,1625,1136,1245;20;F
61296;1311,1057,1612,178,1585,1644,1128,1265,1421,506,1563,1245,1611,1588,1002;57;F
61303;1591,1141,1612,1139,480,1168,1311,1057,1644,1421,506,1563,1594,482,1576;44;F
61522;1588,1585,1545,1280,1563,1168,1311,178,162,1002,1128,1421,1245;48;F
61589;1588,1057,1591,1545,162,1644,1596,1280,1625,1421,1136,1626,1611,1245,1594;47;F
61714;1545,1644,1280,1245,1135,1563,447,1057;42;F
61834;1545;33;M
61909;1128,1136,1576,1311;37;M
62211;178,1139,1421,1576,1245,363,162,1244,1311,1136,1131,204,115,1280,720;37;M
62308;720,242,1057,1553,1671,1412,574,1244,1265,1421,506,1245,204;72;M
62325;1594,506,242,1139,1135,1057,1612,178,1141,1545,1002,576,1136,447,1245;40;F
62359;1563,1245,1311,1545,1596,1280,1128,1353,1136;34;M
62553;1591,1644,1265,1139,1057,1545,1002,1280,1421,1136,1563,1611,1245,1594,482;60;F
62570;242,1561,1245;33;F
62651;178,1002,1573,480,1588,1311,1585,1545,1280,1128,1136,1421,1563,1576,482;30;F
62676;1139,1057,178,1545,162,1412,1421,1590;48;F
62753;1588,1421;59;F
62768;480,1168,1311,178,1545,162,1421,1563,1611,482;40;M
62860;1057,1644;30;F
62937;178,1671;58;M
62994;506,581,1245,178,204,1057,1594;20;F
63101;242,204,178,576,447;58;F
63208;242,1135,1168,1311,1576,1069,1245,447,1611,1671,178,1139,204,1612,363;36;F
63228;1563,1168,204,1421,1136,506,1611,1576,482,1644,1545,178,1311,1588,480;39;M
63251;1139,1545,1563,1245,482,1588,1644,1002,1611;34;F
63281;1644,1128,482,1545,1585,1311,1131,726,1493,1576,1032,1136,1421,720,1245;36;M
63441;506,447,1245,1576,581,1135,1356,486,1136,1412,1545,115,1588,1353,1611;34;F
63491;1588,1545,1644,1002,1563,1611,1245;31;M
63653;1128,1576,482,160,1135,1311,1553,1545,1002,1625,1136,486,1280,1245,1421;48;F
63654;1611,1493;40;M
63657;1493,363,1576,1245,1611,506,576,1265,1128,1412,178,1057,1473,1131,1135;36;M
63687;1611,1594,506,160,1168,1135,204,242,1057,178,574,1128,1421,1245,1576;47;F
63741;1139,1553,1545,1265,576,1136,1032,447,1135,1311,1057,178,1421,1590,506;26;F
63934;204,574,506;30;M
64125;178,1612,1135,720,1131,1473,1311,581,1057,1412,1644,1128,1590,1611,1245;45;F
64243;204,242,1139,720,1131,1311,1057,178,1545,1644,1280,1136,486,1245,1493;36;F
64273;1002,1245,363,482,1545,720,1553,1563,1576,1493,1625,162,1311,726,160;28;M
64332;242,1671,1412,1353;30;F
64333;1412,1353,574,204,506;3;F
64405;447,486,1265,1585,115,1588,1168,178,1545,162,1644,1002,1421,1611,482;38;F
64434;242,1356,1561,1671,1412,1353;1;M
64443;482,1576,1136,1421,1128,1280,162,1545,160,1311,1131;25;F
64715;1561,1671,1596,1128,576,1573,1057,204,720,1473,1412,1353,1032,1590,1493;32;F
64753;1311,581,178,1585,1591,1545,1382,1280,1128,1244,576,1136,1590,1563,447;31;F
64836;1311,1057,1136,1032,1245,1545,162,1644,1280,1421,486,1563,1611,1594,363;45;F
64858;178,1585,1545,1596,1382,1280,574,1128,1265,1136,486,506,1611,447,1493;39;F
65006;1576,447,1245,1563,506,1625,1128,1280,1545,1553,1311,581,178,1421,1136;47;F
65017;720,1131,1473,1057,1545,1280,1128,1136,506,1563,1245,1069,1311,1644;33;F
65025;1576,1611,486,1421,1128,1553,1588;30;M
65072;726,1139,242,480,204,1588,1311,178,1596,1280,1128,1421,1245,1576,363;42;M
65599;1311,1545,1136,506,447,1057,1141;43;M
65639;1563,1244,1002,1412,160,1057,1311,1131,1168,1139,480,720,242,204,115;33;M
65838;1245,1493,482,363,1612,160,720,1131,1311,1057,1545,162,1412,1136,1032;40;F
65911;1135,178,1353,1245,1553,160,1244,1002,1311,1131,1128,1280,1136,1493,482;38;M
65912;1057,1069,160,178,1141,1128,1625,506,1245,1594,1545,1135,204,1421,1611;19;F
65956;1473,1311,178,1545,576,1136,447,204,1057,581,1412,1671,1032,1576,1573;40;F
65979;1588,1585,1002,1545,1280,1128,1421,1136,1576,482,720,1139,1131,1311,1057;27;M
66076;1545,726,1057;26;F
66145;115,1356,1311,1545,162,1644,1002,574,1128,482,1493,506,1563,1611,1594;39;M
66225;1576,576,178,720,204,1245,1032,1412,506,1356,1590,1280,1131,1136,1311;41;F
66345;1563,482,1576,1128,1585,1553,1311,1473,726,1168,1024,1139,480,720,115;27;M
66453;1563,480,1588,1585,1545,1002,1128,1421,1136,1611,482;47;M
66495;1032,162,726,1576;36;F
66554;726,1131,1311,162,1644,1002,1032,1576,1493;61;F
66592;1576,1136,1644,1545,480,726,160,162;73;F
66621;204,480,1588,1311,1057,1421,1136,1611,447,1245,482,1563;25;F
66680;506,1563,1576,363,482,1057,1135,1588,480,115,1168,1002,1136,1611,1245;39;F
66701;480,1588,1585,1002,1128,1421,1563,1611,482;48;F
67412;576,1136,447,1573,482,1493,1265,1128,574,1644,1545,1141,1311,1245,1576;27;F
67435;1553,204,1135,1168,1131,178,1002,1128,1421,1136,1611,1311,1545,1245,482;43;F
67450;1421;51;M
67467;204,242,1057,178,1412,574,1245,1576;33;F
67529;1591,1612,1135,242,1588,1139,1168,1057,1671,1545,1644,1382,1421,1626,1576;27;F
67552;115,1168,726,1131,178,1671,1265,1141,1412,1353,1590,1139,1473,1644,1611;28;M
67608;1563,1493;56;M
67627;1311,1545,1136,1131;27;F
67664;1311,1168,480,720,1131,160,1382,1545,1412,1128,1244,1421,1136,486,1594;33;M
67690;1644,1168,1057,160,1611,1069,720,1311,1136,1131;30;F
67714;1069,1245,1611,1421,1128,1671,178,1612,1311,1135,242,204,1131,1412,1353;32;F
67827;1588,1626,1069,178,1131,480,1135,1561,1671,1412,1644,1032,1611,1245,363;38;F
67910;1588,1135,581,1671,574,1265,576,1590,447,1245,204,178,1141,1412,506;47;F
68025;1588,1002,1611,447,1245,1594;37;F
68116;486,363,1644,1128,1002,1590,1069,1135,506,1168,1591,1245,1594,1576,242;45;F
68118;178,506,1493,482,1576,1245,1611,486,1136,1280,1545,1473,1135,1139,1168;40;F
68252;204,1131,1311,1057,1553,178,1545,1412,1280,1128,1421,1353,1136,486,1245;32;F
68291;1573,115,720,1588,1139,1311,178,1545,1412,1596,1421,1353,1590,1245,1576;38;F
68432;1588;41;M
68588;1573,482,1493,1128,1057,1139,1588,720,204,1135,1131,1311,178,1421,1245;26;F
68751;482,1545,1280,1128,1136,726,1311,1553,160,162;27;M
68944;1356,1245,1128,1139,1671,204,506,1057,178,1412,574,1265,576,486,1136;31;F
68965;204,1588,1553,1139,1135,1131,1311,178,1141,1545,1280,1421,1136,1245,1069;27;F
69028;1168,1131,1473,1493;34;M
69033;178,1545,1611,1576,1573,363;16;F
69198;1382,1280,1244,1493,1168,1591,1136,1245,1576,1588,1135,1585,1545,1421,1611;48;F
69278;480,1588,1168,1311,1591,1545,162,1382,1244,1421,1136,1245,1576,482,1493;9;F
69347;1136,1588,1139,1553,1585,1591,1644,1625,1563,1611,1576;77;F
69434;720,1135,162,1421,1590;28;M
69509;576,1421,204,720,242,1131,1311,178,1545,1280,1136,482,1493;15;F
69571;363,1611,1421,1280,1002,1553,1311,1588;93;F
69602;204,1135,1311,1057,178,1545,1280,1136,447,1576,486,506,1245;60;F
69657;1545,576,447,574,204,1139,178;52;M
69735;1002;50;M
69807;1057,726,720,1032,482,1136,1625,1002,1585,1131,1588,1168,1311,1553,1280;33;F
69924;1588,1311,1585,1002,1421,1563,1576;37;F
69950;1473,1612,1671,1644,574,486,506,1576,363,720,1353,1032,1590,1245,1573;33;F
69954;1545,1576,482,1563,1002;47;F
69982;1311,178,1591,1561,1545,1644,1136,1356,1588,1135,1412,1280,1353,506,1245;31;F
70130;1671,1002,1311,1168,1588,1128,1421,1136,506,1611,1493;31;M
70213;480,1311,160,178,1671,1545,162,1644,1136,506,1493;70;F
70226;1588,1168,1311,581,1057,160,178,1141,1644,1382,506,1069;15;F
70256;1612,1311,1168,1139,363,1280,1421,1136,1611,1576,1588,1493;39;M
70306;1588,1553,1421,1611;45;M
70444;1244,1280,1128,1136,1611,1563,1245,1576,1493,1131,1311,1057,178,1421,447;38;F
70456;1473,480,726,1311,160,1644;23;M
70483;1131,1168,1135,242,204,115,1245,482,363,1588,1311;41;F
70510;1135,720,1131,1585,1002,1280,1128,1244,1421,1563,1493,482,1311,1671,1136;48;M
70555;204,1131,1311,178,363,1545,1382,1280,1128,1265,1421,1136,1611,1245,1573;31;M
70571;720,1057,178,1585,480,1563,1128,1588,1311,1280,1421,1136,1611,1576,482;37;M
70656;363,1069,1576,1245,447,1136,1280,1588,1139,1057,178;47;F
70767;720,1135,726,160,1141,162,1590,1245,1573;36;M
70879;1135,1311,1057,178,162,1421,1032,1545,1412,1280,1244,576,1136,1590,1245;61;F
70939;1625,115,1588,726,160,1612,162,1002,1244,1131,1311,581,1545,1136,1245;23;F
70972;1612,1591,1141,1412,574,1245,1594,1573,204,1057,178,1545,1353,1590,506;33;F
71092;1311,1135,480,1069,1576,1594,506,574,1596,162,178,1057,204,1644,1563;50;F
71132;1135,1141,720,1057;34;M
71150;1576,1245,1611,1136,1421,1128,1280,1002,1545,1591,178,1612,1311,1168,1588;46;F
71193;242,1412;31;F
71239;480,1168,178,1644,1002,1626,1611,1245,1576;35;F
71344;1588,1612,1590,447,1245,363,1493;41;F
71346;1135,1585,1591,1596,1002,1280,1625,574,1421,486,1626,1611,1245,1576,363;35;F
71409;1245,1002,1311,1024,1588,204,1585,1128,1611,482;36;M
71427;1611,1588;47;M
71568;1553,1585,1545,1002;20;M
71570;162,160,1576,1553,1311,1421;31;M
71694;1588,1168,1311,1644,1382,1002,574,1128,1421,1136,1563,1611,1576,1493,482;35;M
71695;1002,1561,178,160,1311,1168,242,1588,1057,1412,1644,1382,1353,1563,1611;30;F
71788;1588,1139,1135,1131,1057,160,1545,1280,1128,1136;43;F
71934;1002,1128,1611,1057,480,1168,726,1311,178,1644,1626,506,1563,1576,482;42;F
72197;1612,204,1596;29;F
72210;204,1596;35;M
72221;178,1545,1002,1280,574,1128,1265,1421,1136,1032,1590,1563,447,482,1493;47;M
72250;178,1057,1563,1594,363;47;F
72251;1135,1588,178,1545,1644,447,480,1311,1002,1128,506,1563,1594,1576,482;50;F
72294;1311,1265,1625,1576,363,1135,1057,178,1002,1421,1563,447,1245,1594,1573;59;F
72371;1412,1311,1032,1136,1421,1280,1002,1545,178,1057,1131,242,204,482,1493;46;F
72448;1128;33;M
72451;204,720,1131,1473,1311,581,1057,1545,1644,1002,1280,1128,1136,1611,1493;12;M
72591;1131,1128,482,1421,1563,1611,1493,1588,1168,1311,1057,178,1545,1644,574;26;F
72604;1382,1644,1671,1585,1473,726,720,480,242,1311,178,1545,1412,1245,482;30;F
72632;1131,480,726,160;25;F
72636;1421,1280,162,178,160,1057,1311,726,1168,1135,1139,720,115,1136,1563;32;F
72822;1311,1588,1139,1168,1057,1280,1626,486,1245,1576;26;F
72906;1588,1473,1311,1128,1421,1611,482,1493;23;M
73273;1473,1311,1002,1576,1573,363,1139,1131,1612,1265,1421,486,1590,1611,1245;38;F
73426;1545,1412,1002,1128,1421,1353,486,482,363,1576,1590,506,1611,1563,1493;35;F
73454;1139,1588,720,1131,1473,1311,1057,160,1545,1644,1421,1136,1590,1611,1493;29;F
73478;178,576,447;66;F
73515;1626,1594,1576,1069,581,1135,1139,1311,1131,1057,160,178,576,506,447;46;F
73651;204,480,1588,1139,1135,1057,1585,1545,1644,1596,1421,1611,1245,1576,482;40;M
73671;204,242,1588,178,1585,1141,1545,1644,1002,1280,574,506,1611,1245,1069;44;F
73705;1588,1311,581,1057,1612,178,1585,1141,1545,1421,486,1611,1245,1576,1573;15;F
73712;1671,1135,178,1128,1590,242,1588,1139,1057,1591,1141,1412,1265,1421,506;48;M
73807;726,1421,1576,1280,160,1553,1311,1136,1131;36;M
73810;178,1545,1353,506,1311,1057,1576,1644,1596,1280,1245,1421,1128,480,482;32;M
73896;115,242,1135,160,178,1412,1280,574,1128,1245,1594,1591,1590;42;M
73998;1585,1596,1002,1626;39;M
74445;1493,1136,1311;34;F
74516;1573,1245,1590,178,1057,1032,1128,1280,1644,1545,720,1139,1311,1473,1493;21;M
74537;1136,1421,1280,1644,162,178,1585,1311,1131,726,1135,1139,720,1545,1128;25;F
74573;178,1493,1626,1032,1069,1265,1128,162,1671,1141,1057,581,1131,242,1412;39;M
74681;1563,1128,1545,160,480,1131,1311,1644;32;F
74817;115,1311,1545,1644,1128,1136,506,1245,482;35;F
74834;1588,1356,480,1135,1168,1311,1671,1382,1002,1421,506,1611,1245,1576,482;43;M
74839;178,1131,1588,480,1135,1311,1057,1545,1644,1280,1421,1136,1245,363,482;31;F
74869;1545,1245;28;F
75226;720,1311,160,1545,1493;33;F
75342;1139,1168,1311,160,1591,576,506,1576,482,1588,1057,178,1421,1611,1245;70;F
75357;486,1136,1353,1421,1625,576,1265,574,1280,1382,1644,162,1671;32;M
75529;1057,178,1671,576,1588,1139,162,1412,1644,1128,1244,1265,1625,1032,1590;27;M
75585;1545,1128,1136,1576,482;38;M
75909;1644,1002,1280,1421,1136,1611,482,1493,1588,1311,1057,1545,1245,506,1563;38;F
75924;1412,1265,1353,1590,1245;38;F
75946;178,1136,1576,480,1588,1168,1057,1612,1545,162,1382,1280,1265,486,1611;41;M
75961;480,1588,1421,1563;41;F
75974;204,1131,581,1057,178,1585,1545,1644,1596,1280,1421,1626,1245,1576,1069;15;F
76040;1588,1311,1002,1421,1611;35;M
76115;482,1588,1311,1057,1545,1644,1002,1280,1421,1136,506,1563,1611,1245,1493;40;M
76135;482,204,1168,1131,1311,581,1412,576,1421,1611,1245,1493,1473,178,1057;21;M
76195;482,1611,506,1280,480,1311,1644,1563;11;M
76207;1131,726,1139,1588,1311,1585,1280,1128,1136,1611,1576;50;F
76282;1421,1563,447,1594,482,1644,1545,178,1553,1057,581,1168,1588,480,204;57;F
76380;1168,1311,1644,1002,1280,1625,1421,506,447,1576;44;M
76395;1128,1626,1245,1576,482,363,1168,204,242,1588,1585,178,1611,447,1573;40;F
76414;1591,1412,1128,1625,1421,1626,506,1245,1576,1069,204,242,178,1280,1611;36;F
76445;1128,1139,480,1588,1311,1057,1671,1545,1644,1002,1265,1421,1611,1576,482;39;M
76463;1139,242,480,115,1311,581,1057,1644,1625,1421,506,1563,447,1245,1069;50;F
76633;1168,178,1382,1612,204,1588,242,1591,486,1611,363;41;F
76669;1356,1135,1545,1280,574,1128,1136,506,1563,1611,1245;30;F
76745;1311,178,1644,1002,1594,1612,1057,1168,242,1588,1280,574,1611,1245,363;41;F
76785;726,1311,581,160,178,1591,1545,162,1002,1421,506,1563,1594,1576,482;46;F
76863;1002;29;M
76911;1576,204,242,1588,1168,1311,1612,178,1644,1002,574,1611,1245,1594,363;42;M
76926;1002,1493;28;F
76975;1611,447,1625,576,1545,178,1588,242,204,115;64;F
77005;720,1356,1135,1311,1141,1561,162,1412,1265,1353,1590,506,1245,1573,1493;34;F
77022;1591,1128,1590,1563,363,1135,1311,162,1280,1245,1594,1493;18;M
77055;1611,1412,204,242,1057,178,574,447;38;M
77075;1141,1128,486,1311,1280,1421,1136,1245,482,1588,1057,1644,1563,506,1594;22;F
77142;1576,1493,1131,1135,1591,1594,482,1421,1136,1245,1311,1545,1002,1280,1563;47;M
77258;1612,204,1588,581,1057,178,1591,1644,1002,1280,574,1353,506,1245,1594;35;F
77476;1280,178,1545,1596,1024,1168,1553,1421,486,1594,1626,1591,1002,1576,1245;19;F
77507;1311,1591,363,1626,178;47;M
77545;482,1136,1473,1588,1139,1311,1591,1545,1644,1625,506,1563,1611,1576;53;F
77548;1545,1644,1280,1421,1136,1563,1594,1576,480,1588,1135,1057,1611,1245,482;48;M
77572;1265,1128,1280,1596,160,204,178,1545,162,1412,1576,363,720,1473,1311;44;M
77621;204,178,1002,1421,1611,1245,482;37;M
77694;1591,1585,480,1356,1588,1024,1135,1311,1057,1412,1644,1002,1421,506,1245;31;F
77699;1545,1626,1590;42;F
77732;204,178,1421,1611,1245,1576,482;11;F
77759;204,178,1421,1611,1245,1576,482;9;M
77779;115,1671,574;49;M
77786;204,178,1421,1611,1245,1576,482;6;F
77908;574,204,242,1057,178,1412,1611,447;38;F
77910;1135,1311,1591,506;31;F
77939;1588,178,1585,1545,1280,574,1136,1626,506,1611;41;F
77953;1473,1135,1139,1588,204,115,242,162,1644,1002,574,1128,1353,447,1594;40;F
77961;1553,1585,1545,1002,1128,447,1245;41;M
78155;1128,486,1590,447,1311,178,1545,162,1280,1244,1136,1245,1576,1573,482;43;F
78336;480,1311,1612,1545,1128,1136,1563,1245,1576,363;37;F
78389;1545,1553,1024,242,480,1588,1168,1311,178,1585,1002,1280,1421,1563,1576;67;F
78416;1139,1421,506,1611,1576,482,1493,1588,1135,1168,1057,178,1265,1245,1069;22;F
78478;576,482,480,204,242,1588,1168,1311,178,1545,1265,1136,1563,1611,1576;35;F
78481;486,480,1356,1588,1311,1563,242,1412,1611;38;M
78487;1128,1002,1136,1626,1563,1611,1576,482,1588,1168,178,1585,1545,1280,1421;48;M
78608;1244,1057,581,1131,1588,1135,1168,1311,178,1545,162,1280,1136,447,482;65;F
78680;1563,1421,1644,1057,1311,242,204,1594;36;F
78838;480,1131,1553,1576,1057,1591,1644,1244,1421;25;M
78884;1280,1057,1311,1245,178,1545;33;M
78887;1311,1585,1002,1136,506,1611,1588,480,1057,1545,1644,1280,1421,1245,1576;34;F
78896;1311,1588,1563,480,162,1168;44;F
78990;1280,1596,1553,1135,1139,204,1057,1612,178,1671,1545,1412,1032,1590,1245;41;F
79012;480,242,1588,1135,1057,178,1280,574,363;34;F
79015;1139,1311,1245,1069,1135,1141,506;47;M
79051;720,1131,1311,1057,162,1412,1644,1353;33;F
79130;242,1245,1353,1128,1588,1611,1168;32;F
79163;204,242,1057,1612,178,1671,1545,1412,576,1136,1590,506,1245,1573,363;41;F
79173;1131,1311;28;M
79375;1141,506;21;F
79392;1128,1576,506,1473;37;F
79436;574,506,178,1141,1353,1576,482,480,1356,1057,1644,1421,1594;29;M
79497;1611,1245,720,1545,1280,1590,506;65;F
79524;1626;46;M
79614;1139,1135,1131,1473,1311,1057,178,1671,1545,1644,1002,1280,1353,1611,1576;45;F
79634;1611,162,1545,1135,581,1591,1626,1594,1057,1128;30;F
79775;115,1057,160,1644,1280,1136,486,1626,1611,1493,480,1545,1245,1576,363;38;F
79823;162,1139,115,363,447,1168,1588,178,1545,1596,1002,1421,1136,1626,1611;43;M
79824;506,1671,1561,1141,1311,1168,1356,204,1588,1135,1591,1545,1002,1353,1611;33;F
79884;1612,1057,1588,480,1563,1611;40;F
79916;1576,178,1139,1135,1057,1141,1412,1590,1245,1069,363,204,1671,574,506;40;F
79917;178,1280,1265,363,506,1590,1136,1545,1671,1612,1057,1311,1135,1245,1069;44;F
80135;1311,1588,1168,1057,178,1591,1545,1002,1421,486,506,1611,1245,1069,482;64;F
80155;1421,1563,1594,1576,1139,1057,1493;33;F
80369;720,1311,160,1128,1625,1626,1245,1576,1057,162,1412,1244,1265,1032,1493;33;F
80391;1588,1168,1311,1057,178,1591,1545,1002,1421,486,506,1611,1245,1069,482;67;M
80466;482,1563,1128,162,1545,1311,1168;31;M
80526;242,581,1057,178,1412,1002,574,576,1032,506,1563,1611,447,1245,1594;65;F
80638;1139,1057,1591,1421,1594;22;M
80643;1135,1644,1280,574,1625,1136,1245;31;F
80644;115,720,1311,1057,162,1265,1576;33;M
80698;480,1576,482,1136,486,1625,1002,178,1311,1057,1168,1139,1588,242,1545;45;M
80699;581,1473,1135,1139,204,1002,1136,1588,1168,1128,1563,1032,1611,1245,1576;45;F
80782;160,1545,1644,1280,1128,506,1069,363,1588,242,1135,1421,1611,1576,1245;40;F
80784;1644,1280,1136,480,1311,1545,1421,1563,1245,1576;34;F
80794;480,1139,1311,581,1057,1591,1141,1545,1421,1136,486,1563,1245,1576,1493;44;M
80795;1139,1131,1311,1545,1245;28;M
80906;115,204,720,1131,1057,178,162,1244,1032,1590,1245,1576,1493;40;F
81024;1353,1421,574,1671,1561,1591,178,1382,1002,1128,576,506,1611;35;F
81099;1139,1135,1545,574,1625,1136,486,1611,1245,1576;22;F
81104;1588,1168,1131,1311,581,1585,1545,1644,576,1421,1136;28;F
81117;1139,1311,178,1002,482,1245,1563,1611,1265,1421;44;F
81133;1412,1356,1057,1280,1032,506;66;F
81151;160,1553,1131,1311,1057,1545,1644,1002,1280,1136,486,1576,1573,482,480;26;F
81230;1136,1245,1576,482,204,1588,1135,1168,1612,178,1671,1280,506,1611,363;32;F
81270;1588,506,1611,1069;43;F
81304;1131,1311,1545,1128,1421,1563,482,1139,1135,1168,581,1057;33;F
81450;204,1135,1131,1545,1644,1421,1245;24;F
81492;1612,178,1644,1280,1625,1136,506,1576,1590,242,1057,1545,1591,1245,1594;50;M
81543;1594,115,480,1588,1168,1612,178,162,1644,1002,1421,506,1563,1611,1245;42;M
81596;1311,162,1265,506,1069,720,1590;44;F
81617;204,1135,1057,1612,1002,1421,1280,1069,1545,1128,1245,178,242,1611,1588;34;F
81675;242,1128,1611,482,1588;34;M
81825;1057,480,1032,1136,162,1131,160;32;M
81846;1265,574,1382,1545,1585,204,242,1588,178,1591,1128,1611,1245;40;F
81971;162,1128,447,1594,363,1576,1069,1588,1135,1168,1057,160,1421,1611,1245;53;F
82081;1588,1135,1131,1545,1002,1280,1265,1421,1136,1611,482,1311,178,1128,1245;44;F
82092;720,1135,1057,1141,1591,1561,1671,1412,1644,1590,506,1611,1245,1576,1069;41;F
82149;1245;29;F
82158;1135,1563,1576,160,1244,720,1002,1588,1131,1311,1545,1280,1136,482,1493;22;F
82284;1644,1596,1280,1128,1265,1625,1421,1136,1032,1590,1563,1245,1594,1493,1576;31;M
82317;1311,1545,1265,1136,1245;22;F
82416;1573,162,160,720,1135,1590,1245,1594;63;F
82457;204,1588,581,1057,178,1591,1545,1002,1280,1136,1563,1594;39;F
82458;204,115,720,1139,1135,1131,1057,1612,1141,1412,1421,1590,447,1576,363;46;F
82623;506,162,1545,178,1311,1139,1356,204,242,1588,1353,486,1611,1245,1576;35;F
82631;1131,726,480,1280,1128,1421,1136,1032,1563,1611,1576,482,1493,1311,720;34;F
82698;482,1280,480,242,204,726,1644,1596,574,1563,1245;36;M
82739;115,1131,1168,1356,480,204,1057,178,1545,1128,1611,1576,1135,1588,1421;31;F
82753;1356,1057,178,1412,1280,1032,506;72;F
82795;720,1311,1591,1141,1136,1245,1576,1588,1131,1545,162,1002,1128,1421,1611;48;M
82991;1588,1135,1311,1057,178,1625,1421,1611,1245;50;F
83025;1057,1585,1002,1644,1612,1311,115,1588,1168,1131,160,1545,1280,1421,482;40;M
83059;1588,1141,1644,506,1563,1069;36;M
83139;204,1002,1493,1245,1421,1625,1596;30;M
83205;162,1135,726,1311,160;30;F
83257;204,115,447,720,1168,1131,1563,1245,178,1382,1002,1493,1353;31;F
83342;1265,1128,1280,1644,162,1591,1585,1311,1473,1131,480,720,486,1594,1573;32;F
83463;726,1131,1585,1128,1563,1245,1576,1493,482,480,1311,1545,162,1644,1002;46;F
83516;1069,1594,1353,581,178,1585,1591,1002,506,1611,482,1311,1057,1421,1245;32;F
83522;115,720,1128,160,1671,1545,162,1412,1644,574,1353,1136,1032,506,1493;40;F
83609;1585,482,1573,115,204,1139,1588,1168,1545,162,1382,1421,1136,486,1576;31;M
83672;1588,178,1545,1002,1280,1245;21;F
83815;482,1128,480,1563;32;M
83827;160,1136,1576,482,1311,480,1139,1545,1563;31;F
83845;1136,486,1563,447,1588,1057,1553,178,1585,1545,1280,1625;42;M
84003;204,1131,1280,576,1136,447,506,1057,178,1412,1265,1032;57;M
84027;1353,1136,486,1626,1032,1590,506,1563,1611,363,482,1245,1594,1576,1069;58;F
84143;204,242,1057,1612,178,1412,574,1136,1032,506,447;26;M
84167;581,160,1596,1245;24;M
84234;1311,1585,1671,1545,1644,1002,1280,1128,1421,1563,1611,1245,1576,363,482;32;M
84306;506,1002,480,1135,1131,1611,1311,1057,178,1545,1644,1563,1245,1594,482;36;F
84391;480,1135,1168,1311,1591,1563,482,1002,1421,1136,506,1585,1545,1280,1245;48;F
84428;1576,1245,1611,1136,1421,1280,1002,1382,1644,1545,178,1057,1168,1588,204;52;M
84460;1136,1128,1168,1139,1588,480,1311,1585,1591,1545,1002,1625,1421,482,1576;49;F
84564;1057,1493,720,1131,1311,178,1545,1002,1280,1128,1421,1136,1245,1576,482;55;M
84595;1545,1611,1245;39;F
84605;1131,1128,1136;5;F
84619;1311,1585,1591,162,1545,1002,1280,1128,1625,1421,1136,1563,1245,1576,482;74;F
84641;1136,1131,1128;3;M
84685;1128,1131,1136;;M
84703;1245,1382,1280;37;F
84754;242,1057,1612,178,1671,1412,576,506,1611,447,363;39;F
84790;1057,178,1545,1002,1280,1625,1136,1493;59;F
84840;1588,1168,1671,1644,1382,1353,1611,447,1245;34;F
84862;1553,1311,1131,1473,1168,1588,1545,1563,1128,1421,1136,482;15;M
84869;1136,1625,1128,1644,162,1545,1591,1585,1057,1311,1135,1588,1168,1280,482;28;F
85160;720,1311;30;M
85255;160,1545,1644,1002,204,480,242,178,1596,1625,1563,506,447,1245,1594;55;M
85291;204,1057,1612,1671,1412,1611,1245;37;F
85369;115,204,480,242,1588,1139,1311,178,1591,1545,1644,1596,1128,1421,1136;20;M
85385;1245,1135,1141,1573,1553,1590,720;24;F
85388;115,720,1139,1131,1311,581,1057,1585,1545,1644,1280,1136,1245,1576;31;F
85412;1280,1311,581,1057,1585,1545,162,1644,1002,1128,1421,1136,1563,1611,482;55;M
85435;1002,162,1671,1311,1356,480,1644,1421,1563,1611;34;M
85449;242,1588,1135,178,1644,1596,574,576,1625,506,1611,447,1245,1594,1493;21;F
85605;1128,1590,1493,115,1139,1473,1057,1644;24;M
85620;480,726,1671,1545,1382,1280,1244,1421,1353,1136,506,1245,1576,482,1493;31;F
85743;1136,1611,482,1135,1311,1057,1545,1644,1002,1128,1421,1563,447,1245,1069;55;F
85783;1135,1139,204,242,1588,1168,1311,178,1585,1644,1421,1576,363,1611,1245;44;F
86189;1311,1545,1576,1136,1280,1002;52;F
86207;1573,1280,1421,1245,1576,1545,1553,506,178,1136,1131,1626,1057,581,204;20;F
86208;482,447,1611,1563,1136,1421,1280,1644,162,1545,178,1057,1311,1588,480;66;F
86251;1128,204,1032,1069,1135,581,1057,178,1141,1671,1412,1596,1590,506,1245;16;F
86387;178,1141,1596,1280,1265,576,1136,1032,482,204,720,726,1311,162,1573;32;M
86463;1382,162,1612,480,1563,1576;38;M
86511;1585,1002,1128,1594,1576,1493,1135,1057,1545,1280,1625,1421,1136,1563,1245;23;F
86717;1353,1356,1139,1131,581,1612,1128,1563,1245,1576,482,1311,1057,178,1545;31;F
86756;480,1473,1057,178,1591,1644,1002,1265,1625,1626,1590,1611,1245,1573,1493;49;F
86815;506,1421,1280,162,1545,1141,178,1057,1311,1168,1588,363,1139,1245,1135;23;F
86859;1421,574,1596,1545,1168,1588,204,1136,486,363;45;M
86889;726,1311,1585,1591,1141,162,1644,1002,1136,1626,1590,1611,1245,1576,482;46;F
86972;115,720,581,1057,1002,1265,1625,1626,1245,1594,1473,1493;24;F
86975;574,1563,1611,1245,506,1596,1141,178,581,1311,1473,1135,480,1057,1421;36;F
86990;1168;69;F
87004;1057,1128,1244,1265,1136,1611,1576,1356,1545,1412,1353,1139,1135,1590,1245;37;F
87013;1002,204,480,242,1588,1057,1585,1545,1280,574,1421,1563,1611,1245,447;39;F
87149;1473,726,1135,242,1356,1139,1311,581,1421,1245,1594,1069,363,482,1493;28;F
87194;1545,1280,1265,1136,482,480,1135,1311,1644,1596,1128,1421,1563,1594,1576;31;F
87233;1576,1563,1168,482;26;M
87296;1128,1493,482,1573,1576,1069,506,1135,1311,1057,178,1545,1136,447,1245;47;F
87327;1590,1563,1594,363,1356,1588,1168,1585,1591,1644,1002,1421,506,1611,1245;45;M
87340;178,1311,480,1057,1141,1545,1644,1280,1136,506,1245,1576;45;F
87360;1553,178,1545,1002,1128,1421,482;26;F
87455;1625,1032,1245,1493,482,1136,1128,1280,726,115,480,1588,1545,1576,1421;37;M
87469;242,1576,482,160,204,1611,1563,1280,1644,162,1545,178,1057,1588,480;43;M
87472;1588,480,115,1493,1611,1421,1280,1168,1057;35;M
87485;1473,1493;51;F
87516;1135,1625,1590,1245,1573;49;F
87583;482,480,1588,1135,1168,1311,1057,178,1644,1002,506,1563,1576,1493;39;F
87614;720,480,1588,1139,1473,1002,1168,1057,1421,1136,1563,1576;34;M
87779;1168,178,1591,1141,1644,1002,1421,486,506,1611,1245,1594,1576,1069,363;50;F
87852;720,1128,1135,1131,1311,1057,1561,1671,1412,1265,1136,1032,1245,1590,506;39;F
87922;480,1135,1131,1311,1545,162,1644,1421,1136,1590,506,1245,1576;28;F
87963;1131,1002,1128,482,1135,1311,1057,1545,1280,506,1563,1493,1356,1245,1594;36;F
88088;160,178,1128,720,1135,1131,1473,1311,162,1421,1032,1590,1611,1245,1576;26;F
88258;1280,1585,1057,1311,115,720,1131,1545,1128,1244,1136,1563,1245,1576,482;22;M
88461;242,1563,1545,1002,178,1588,480,204,1421,1611;9;F
88530;204,1139,1135,1131,1057,1612,178,1141,1561,1671,1545,1412,1265,1590,506;33;F
88538;506,447,1353,1671,1561,1057,204,242,1588,1135,1168,178,1545,1280,1245;36;F
88542;1057,1135,204,480,1588,1311,1473,178,1671,1545,162,1644,574,1625,1611;41;F
88615;162,1473,1588,726,1311,160,1576,1545,1590,506,1280,1265,1421,1136,1493;60;M
88675;1612,1585,1141,1545,1412,1644,1280,1421,1563,1245,1594,1493,1135,1311,1057;27;F
88959;1136,1353,1244,1135,242,1356,178,720,1141,160,726,162,1573,1590,1245;38;F
88996;1057,178,1591,1644,1382,1280,1421,480,1135,1625,506,1245,1576,1493,1573;41;M
89002;178,204,480,581,1611,1576,115,1139,1168,1057,1596,1128,1265,1421,1626;47;M
89011;1002;42;M
89179;720,1356,726,160,1141,162,1280,1244,1353,1590,506,1245,1573;39;M
89399;115,720,242,1356,1139,1311,1612,178,1561,1671,1412,1244,1265,1625,1245;41;F
89410;1136,1545,1585,1131,1057,1382;45;M
89455;1168,1311,581,1057,1553,1141,1671,1545,1644,1280,1625,1421,1136,506,1069;55;F
89471;1625,1128,1382,162,1585,1131,1135,1311,1057,1545,1596,1280,1421,1136,1245;32;M
89559;1644,1311,1139,1135,1671,1545,1382,1280,574,1136,486,506,1611,447,1245;37;F
89601;720,726,1311,1141,1545,162,1280,1244,1265,1421,1136,1590,506,482;61;F
89683;1493,482,1245,1057,1131,115,160;46;F
89721;1382,1626,1588,1135,1168,1612,178,1585,1591,1421,486,1611,1245,1576,363;45;F
89729;204,720,242,726,178,1545,162,1412,1644,574,576,1421,1590,1245,447;34;F
89861;115,1311,1545,1128,1136,1245;38;M
89893;1032,1136,1421,1644,1671,160,1057,1311,720,1131,1128,1280;43;M
89957;581,1139,480,204,1245,363,482,1588,1311,1057,178,1585,1002,1563,1611;46;F
89972;1421,1069,1591,242,204,1311,178,1002,506,1611,1594;37;F
89977;480,1588,1139,115,1057,1671,1412,576,1590,506,1611,1245,1576,1069,363;41;F
90152;115,204,1311,1057,1612,178,1412,1265,1136,1590,506,1245,1594,363;33;M
90163;162,1412,1644,574,447,204,242,1135,581,1057,178,1141,1002,1421,506;23;F
90291;204,242,1588,1135,1168,178,1141,1382,1002,574,1421,506,1611,1245,1576;34;F
90333;1588,1311,1057,1585,1141,162,1644,1128,1611,1576;33;F
90474;1280,1611,1588,1139,581,1057,1545,1644,1002,576,1625,1136,447,1594,482;50;M
90480;1356,1588,1168,1382,1353,1611,1576;33;F
90501;1002,1625,204,1588,1168,1561,1421,1611,363;43;F
90521;1611,1280,1644,1545,1671,1561,1141,1311,1588,1136;42;M
90585;506;39;F
90619;1588,1135,1057,178;18;F
90626;1057,1585,506,1245,1588,1596,1421,486,1611,363;44;F
90737;1135,242,480,204,1168,581,1280,1069,1139,1057,178,1591,506,1245,1594;54;F
90738;1412,1128,1576,447,1136,1625,574,1280,1596,1545,178,204;31;F
90741;1588,1168,1585,1591,1644,1382,1002,1128,1625,1421,1353,486,1611,1245,482;30;F
90762;1265,1002,1382,1644,162,1612,1553,1473,726,1168,480,720,1128,482,1493;27;F
90840;1644,1280,1136,486,1069,1588,1311,1585,1561,1421,1611,1245,1576;37;F
90895;178,1057,1311,1139,1588,115,1671,1412,576,1626,506,1611,1245,1576,363;12;F
90919;1128,1421,1136,486,1563,1611,1245,363,482,1493,480,1311,1057,1545,1576;33;M
90983;581,1553,1612,1591,1561,1280,363,447,506,1353,242,1626,178,1412,1590;38;F
91034;720,1139,1131,1311,1057,1353,1626,1590,1611,1245,1576,363,482;31;F
91055;1311,178,1545;35;M
91153;1139,1135,178,1545,1280,1136,447;45;F
91220;242,1421,1594,482,1493,1576,1671,1611,1588,1002;51;F
91308;1493,1585,1128,1244,720,1135,1131,1311,178,1545,1412,1280,1136,506,482;40;F
91319;1545,1002,574,1136,115,1057,1591,1141,1671,1625,1590,506,1594,1611,1576;38;M
91332;1545,1280,1136,1245,1573,1493;43;F
91422;480,1135,1473,1545,162,1644,1136,1590,1563,1611,1576,1573,363,482,1493;32;F
91510;242,1135,506,1245;44;F
91541;1135,480,115,1588,1311,1591,1671,1545,162,1644,1002,1128,1626,1611,1245;33;M
91601;574,1128,1265,1353,506,1563,204,178,1545,1136,1611,1594;37;F
91713;178,242,1588,204,1311,1553,1545,1002,1353,486,1032,1245,482,1493,1576;27;M
91834;363,482,1002,1382,1644,162,1585,1311,1135,115,1588,1168,1057,1545,1611;41;F
91837;178,1588,1168,1311,1057,1591,1545,1002,1421,486,506,1611,1245,1069,482;89;F
91838;1280,115,1024,1382,1545,204,242,178,1585,1002,574,1421,1563,1611,447;12;M
91983;204,1135,363,1024,1131,178,1280,576,1168,447,1057,1545,1136,1245;48;F
92080;1139,1135,1311,1057,1553,1280,574,506,1032,204,1136,1131,178,1596,1245;36;F
92115;115,720,1139,1591,162,1412,1244,1265,1625,1421,1032,1590,1245,1576,1069;63;M
92191;1311,1245,480,1588;39;M
92224;1545,162,1644,1128,1244,1245,482,1139,1135,726,1311,160;32;F
92314;1311,1057,1545,1644,1280,1128,1265,1136,506,1245,1594,1576,1069,482;46;F
92399;178,1612,1135,242,480,506,1611,1594,204,1311,1057,1671,1644,1245,482;32;F
92400;1588,1311,1585,162,1128,1136,486,1576,482,1168,1545,1280,1421,1611,1245;37;F
92411;204,1168,1311,178,1611,486,1136,1128,1545,1585,1576,482;47;F
92449;480,204,1311,1057,1612,178,1545,1644,574,447,1626,506,1594,1573,1576;45;F
92525;160,1131,1135,242,720,1311,178,1545,1280,1265,1136,1590,506,1245,1573;41;F
92528;1311,1644,1265,506,1576,1069;36;F
92629;115,480,1139,1168,1131,1311,160,178,162,1644,1563,1611,1245,1594,1576;39;F
92830;1588,720,480,1131,1585,1128,1136,482,1576,1493,726,1311,160,162,1421;32;M
92903;720,726,1131,1585,1057,160,1545,1280,1128,1265,1421,1136,486,1032,1576;45;F
92985;204,480,1311,1057,1612,178,1545,1644,574,1626,506,447,1594,1576,1573;12;M
93004;1561,1671,1545,162,574,1421,1136,1131,1412,1128,1265,486,1245,1576,363;34;F
93107;1131,204,581,1057,1573,1596,1135,1311,1545,1136,1245,1493;44;F
93150;1139,1131,1311,178,1024,1168,1553,160,162,1421,1245,1594,482,1493;27;F
93155;1135,1131,1311,581,178,1545,162,1128,1136,1590,1245,1594,1576,482;26;M
93209;1128,1421,1136,1245,242,1588,1135,1168,1057,178,1591,1545,1280,482,1611;62;F
93421;115,1588,1168,178,1280,1421,1626,1611,1576,482;38;M
93494;482,1493,115,720,1588,726,1131,1311,1057,178,1545,162,160;27;F
93726;1245,1576,363,115,1128,1644,1545,1168,1139,480,1136,506,1563,1594,482;47;M
93876;1412,1671,1561,1131,1168,115,1576,204,242,1588,1311,178,1128,1421,1611;36;M
93925;1644,1244,1611,1594,482,1057,160,1412,1136,1353,506,1563,1245,1069,363;33;F
93980;1590,506,1611,1245,363,1553,1280,1128,1135,1131,1311,1545,1421,1136,1576;32;F
93998;1553,581,1131,1128,1245,1576,1069,482,1311,1057,1545,1002,1421,1136,506;51;F
94022;1644,1545,1671,1141,178,1057,1135,1139,480,204,1625,1421,506,1594,1576;23;F
94067;1141,1545,1644,1382,1002,1128,1265,1421,506,1245,1588,1168,1311,1353,1611;36;M
94147;1563,1611,1245,1576,482,160,162,1032,1590,1573,1493,1473,1131,726,720;41;M
94153;1588,178,1545,1280,1421,1136,1611,1493;33;F
94159;1265,1625,1563,1611,482,1131,1311,178,1545,1280,1128,1136,1245,1576,1573;39;F
94452;1590,1136,1671;24;M
94548;1594,178,720,1168,1131,160,480,1311,1553,1545,1280,1136,1245,1576,482;32;M
94555;1545,480,1356,1135,1057,1141,1671,1412,1644,574,1353,506,1611,1245,1594;35;F
94559;1280,1128,1625,1421,486,1611,1245,480,720,1588,1057,1576,363,482,1545;42;F
94601;1311,1545,1280,1625,1136,1245,1576;49;M
94616;1576,1136,1128,1596,1671,1545,1131,726,1135,204,480,1002;30;M
94665;726,1311,160,1585,1545,162,1280,1128,1265,1421,1136,1563,1611,1576,363;50;M
94695;1590,1561,1588,1135,1473,1553,162,1141,1644,1596,1626,1611,1594,1576,1573;30;F
94725;1139,1168,1311,160,1545,162,1002,486,1245,1576;51;M
94768;1131,1168,1588,480,115,1311,1057,1002,1136,1625,1421,1611,1245,1493,482;31;F
94769;480,1576,1585,1588,1545,1245,482,178,1168,1311,1553,1002,1421,1136,1611;54;M
94851;1421,1644,1671,1141,178,1612,1139,1135,1311,1057,1545,1245,1576;35;F
94858;115,480,1588,1168,160,162,1244,1032,1245,1576;23;F
94894;480,1588,1311,160,162,1644,1128,1563;46;F
94923;242,1135,1561,1412,1644,1382,1280,1244,1136,1245,1576;36;F
94972;1553,1245,1136,204,1596,162,1311;33;M
94992;1576,447,1136,576,1280,178,160,204,726;38;F
95043;1421,1644,1128,1563,482,204,720,1139,1131,1311,1057,178,1545,1136,447;29;M
95126;204,1588,726,1311,1545,447,1245,1576,1573,482;13;F
95149;1493,204,115,1421,1596,1644,1057,1412,1576,1245;32;M
95159;1588,1057,1421,1131,1311,1585,1545,1128,1136,486,1563,482,1139,1591,1611;21;M
95161;1168,1421,1576;27;F
95230;1311,1245,1588,1168,1553,1591,1002,1421,1136,486,1563,1611,1594,1576,482;18;M
95336;1128,1576,1136;46;M
95379;1594,204,480,1311,1057,1612,178,1545,1644,574,1576,1626,506,447,1573;9;M
95419;1135,581,1057,1141,506;28;F
95541;363,1002,1588;37;F
95612;204,480,1588,1168,1311,1553,178,1585,1545,1002,1421,1611,1245,1576,482;11;M
95615;1588,1139,1135,160,1591,1644,574,486,1611,1245;23;F
95789;1245,1576,1069,1588,1135,1168,581,1057,1141,1644,1136,506,1611;45;F
95893;1139,1057;60;F
95906;1671,160,1311,1131,726,1168,1139,1588,115,720,1473,1545,1136,1576,1493;25;F
95958;1311,581,1141,1002,1421,1245,1576,1069,363;48;F
95961;1057,447,1245;18;F
95964;1168,1265,576,1032,506,1563,1611,204,1311,1057,178,1545,1280,447,1245;34;F
95972;1135,1131,1311,1644,1280,1421,1245,1576;24;F
95984;1057,1545,1412,1644;31;M
95988;482,1141,1280,1625,1245,1545,1671,1561,204,1135,1612,178,1591,486,363;42;F
95997;1131,1057,1412,1644,1128,1611;36;M
96005;1588,1002,1611;37;M
96101;1493,482,1563,160,1057,1131,1588,115,1311,1545,1002,1280,1128,1421,1136;40;F
96121;1585,1128,1563,482,480,1588,1421,178;54;M
96134;1588,1057,1545,1421,1136,1245,1576;27;M
96151;1493,1594,1626,1139,1135,1057,1141,1545,1265,1136,1590,506,1245,1576,1069;41;F
96219;1611,1245,1057,1644,1280,1353,486,506,1563,1594,1573,1576,1069,482,1493;34;F
96383;720,1644,1280,1128,1353,506,1611,1245,1069,482,1612,1311,160,1576,162;33;F
96480;1057,1644,1421,1069,482;20;F
96482;1131,726,1611,1245,1493,1576,1563,1128,162,160,1057,1473,480,720,1311;27;F
96486;1545,1353,720,726,1131,1311,160,162,1382,1128,1265,1626,1611,1245,1493;32;F
96532;482,480,726,178,1545,1561,162,1280,1128,1625,1421,486,1563,447,1594;65;F
96537;1611,1563,1136,1421,1280,1002,1382,1545,162,1553,1311,1131,1168,720,1493;38;M
96544;574,1002,178,1168,1356,1588,1135,1612,1545,1644,1382,1353,1611,1245,1069;38;F
96648;1245,1611,1353,1588,1168,178,1382;33;F
96660;1421,1353,1245,482,1493,480,1588,1168,1131,1311,1057,160,178,1563,1576;54;F
96837;720,242,1131,1057,1412;38;F
96861;1671,1421;58;M
96894;1671,1545,1280,1128,1353,506,1611,1493,1356,1588,1131,1057,1412,1421,1136;35;F
96907;1563,1588,1382;63;F
96908;1545,1002,1280,1128,1265,1421,1136,506,1563,1245,1594,1576,363,482,1493;47;F
96952;506,480,1545,1280,1128,1136,1421,1625,162,1311,1131,726,1588,720,1576;70;F
97048;447,1382,1002,1545,178,204,242,480,1057,1585,574,1421,1563,1611,482;5;M
97130;480,1671,1412,1644,1128,1244,1245,1576,363,115,1139,1057;41;F
97143;726,1139,480,720,115,1057,1585,162,482,1311,1545,1280,1421,1136,1576;32;F
97161;1421,1625,1265,1002,242,720,204,115,574,1596,1644,1545,1141,1612,1311;43;M
97239;480,1588,1168,1311,1553,178,1585,1545,1002,1421,1136,1611,1245,1576,482;6;M
97312;1131,1612,162,1280,574,1421,486,1136,1588,1135,1545,1644,506,1245,1576;27;F
97360;480,1311,1057,1561,1545,1644,1421,1353,1563;30;F
97420;1136,1131,1553;25;M
97686;726,1131,1311,1057,1576;32;F
97693;581,1135,1311,1057,178,1591,1141,1545,1644,574,1136,1590,506,1594,1069;54;F
97703;720,1139,1473,1311,160,1561,1671,1412,1644,1002,1625;32;F
97806;726,581,1002,1128,1421,1563,1611,447,1594,1280,506,1644,1588,1545,1311;33;F
97945;1545,1644,1002,1128,1625,1421,486,1136,1032,506,1576,482,1168,1131,1311;27;M
97963;1311,1421,720,1139,1131,160,1612,162,1412,1245;30;M
97979;204,1356,1135,242,574,1245,1131,1057,1591,1644,1280,1136,486,506,1002;42;F
98051;115,1057,1141,1545,1265,1421,1245,1594;33;M
98110;1563,162,1421;25;M
98126;1611,160,1131,1139,480,1588,1311,1545,1644,1128,1265,1421,1136,1576,363;41;F
98176;1588,1311,1596,1563,1245;39;M
98177;115,482,363,1573,1245,1136,1280,162,1545,160,1553,1311,1131,1139,720;47;F
98260;1588,204,1131,1545,162,1644,1421,1136,1563,1576,1594,1245;30;F
98313;1588,1057,581,1128,1563,1245,482,204,1168,1131,1553,1002,1421,1136,1611;39;M
98325;1553,1588,1139,1131,1136,1244,486,363,1585,1002,1168,1591,1576,1421,1611;18;M
98463;576,486,1563,1594,482,242,1356,1588,1311,1545,1280,1353,1611,1245,1069;46;F
98475;1128,1644,726,242,720,204,178,1545,162,574,576,1421,1590,1611,447;35;M
98632;1576,1493,204,1588,178,1545,447,482;26;M
98654;1591,1311,1588,480,242,1356,1057,1561,1644,574,1421,1353,506,1611,1245;35;F
98667;1612,363,480,178,1545,162,1002;52;F
98669;204,1141,1382,1353,1611;42;M
98684;720,1139,1135,1131,1057,1412,1280,1244,1421,1136,1032,1590,1245,506,1576;45;M
98705;1311,1168,204,1139,1588,480,1002,1280,1057,178,1421,1611,1563,1245,363;44;F
98725;1473,1412,1032,204,1057,178,482,1545,506,1136,1280,1311,1553,1131,720;15;M
98895;242,1057,1412,1382,574,1280,1421,1136,1245,1594,1139,1135,178,1545,1128;59;F
98903;242,1356,1545,1412,1382,1002,1128,1353,486,1611;40;M
98972;1057,1545,1280,1626,1245,242,1356,486,1353,1611;35;F
98981;115,204,720,1139,1612,178;27;F
99045;720,1131,1473,482,506,178,1421,1311,1280,1245,1244,1136,1128,1057,1032;75;F
99094;204,1032,1245,482,1136,1421,1131,1473,1311,1057,1545,1280,1412,178,506;91;M
99180;720,1141,1473,242,1671,1353,486,1590,1245,1311,1136,1561,1585,1131,1412;47;F
99182;162,1412,576,1421,1136,486,1032,447,1245,1594,1573,1265,506,178,1590;57;M
99228;1585,1002,1594,1136,1563,1265,1128,1311,1588,720,1131,1545,1644,1245,1576;28;M
99322;115,1493,1473,160,162,486,1245,204,1024,1311,1128,1563,1576,1139,1057;16;F
99333;1644,1280,1136,506,204,242,178,1412,574,576,1590,447,1245,1573,363;7;M
99430;1057,1545,1412,1136,1576,1493;33;M
99449;1135,1057,1421,1136,1245;49;F
99463;1135,1057,1671,1545,1412,1245,1576;54;F
99474;1563,363,1588,1139,1311,178,1585,1591,1421,486,506,1611,1245,1594,1576;43;F
99898;1625,1421,1245,1545,204,1382,1002,574,1128,1136,486,1576;30;F
99962;242,204,1588,1057,581,178,1625,1421,1136,1032,1563,1611,447,1245,1594;65;M
99969;1588,204,1131,1545,1128,720,1139,1473,1311,1553,1644,1280,1421,1493,115;42;F
99997;1421;19;F
100026;178,1141,1563,1611,204,480,1588,1135,1168,1644,1382,574,486,1245,1594;33;F
100035;1168;46;M
100119;1245,363,482,1612,1057,242,1024,178,1545,1644,1280,1128,1265,506,1594;72;F
100162;1057,1545,1382,1136,1245,1493;31;F
100286;1473,1588,242,115,1135,1131,1311,1057,1545,1412,1644,1280,1136,506,1245;33;F
100310;1421;53;M
100370;1611,1069,1573,720,1135,1131,581,1057,1545,1412,1644,574,1136,506,1245;29;F
100395;1024,1168,160,1625,1245,1563,363,1588,581,1421;55;F
100688;115,204,1382,1141,1591,726,1135,480,1057,1553,178,1644,486,1563,1576;47;M
100703;1421,1588,1311,1585,1545,1280,1128,1265,1136,1563,1611,1245,1576,1493;37;F
100716;1671,1545,1412,1136,1626,1563,1493,204,1588,178,1644,1128,1353,1245,1611;28;F
100732;1002,1493,482,1573,1245,1563,486,1136,1421,1128,1280,1057,1311,1588,1545;38;F
100745;480,1356,1311,1057,1644,1128,1421,1353,1136,1245,1576;33;F
100757;1057,1563;22;F
100774;1493,1473,1421,1573,1576,1245,1591,1311,482,115,1139;45;M
100828;1280,1421,486,1563,1245,1353,1136,1545,178,1588,1311,1671,1002,1576,1611;35;F
100861;1131,1135,720,1311,1545,162,1280,1136,1245;32;F
100941;486,1545,115,204,726,1553,160,162,1128,1421,1493,720,1131,1311,178;31;F
100964;720,1135,1412,1245,447,1128,1545,1311,1131,1057;50;F
101012;1168,1128,1311,1057,1141,1561,1545,1644,1002,506,204,1135,178,1563,1245;40;M
101213;204,242,1131,1311,1057,178,574,1545,1611,1245,1493;31;F
101233;480,1135,1311,1553,1545,1644,1280,1421,1245,1576;40;F
101262;1135,1590;47;M
101336;1135,1590,1594;39;F
101340;480;31;F
101379;363,204,1561,486,1136,1245,1576,242,1356,1135,1131,1057,178,1353,1412;32;F
101462;1131,1311,1545,1412,1644,1128,1421,1136,1493;39;F
101541;1311,1545,1002,1280,1136,1576,482;71;M
101667;480,115,1545,1128,1136,1563,1611,1576,1069,482,1032,1473,1280;32;F
101690;1136,486,1591,506,363,1139,178,1585,1545,1644,1002,1280,1611,1245,1594;41;F
101832;506,1265,1545,1563,1611,1356,1588,1168,162,1596,1421,447,204,1245,178;32;M
101853;482,1576,1069,1594,1245,1611,1563,1421,1644,178,1553,1311;57;F
101894;1588,1135,1168,1265,1625,1245,482;37;F
101913;1353,204,482,1576,1136,1168,1311,1585,1596,1128,1421,1611,1594,486,363;15;M
101982;1139,1135,160,178,1545,363,1356,1057,1553,1136,1245;27;F
101997;1611,447,1576,1069,1135,1311,576,1421,482,242,178,1545,1644,1280,1245;39;F
102004;1139,1644,1280,1563,1594;30;F
102041;1493,482,1611,1563,1136,1421,1128,1545,720,1131,1311,178,1585,162,1280;36;F
102059;1131,1421,1136,1245,1576;35;M
102243;1356,1382,1245,1311,1002,1128,1563,1131,1545,1280,1136;34;F
102248;480,1573,1141,720,1135,1245,160,162,1244,1590;37;M
102320;1131,1644,1265,486,1032,1245,115,1135,1473,1311,1057,1545,1493,1573,1576;30;F
102369;581,1356,1588,204,242,1168,178,1585,1644,1421,1611,447,1245,363,1069;34;F
102457;1131,1311;34;M
102472;1311,720,1412;30;F
102621;1131,1135,115,1139,1168,1311,1057,1545,1280,1421,1136,1611,1245,1576,482;36;F
102673;1057,160,178,1002,1421,1563,1311,1545,162,1644,1280,1136,1594,1576,482;31;F
102720;1128,506,204,242,1588,1311,178,1545,1280,576,1136,1611,447,1245,363;67;M
102730;581,726,1356,204,1588,1168,1057,160,178,1561,1002,1625,1421,1563,1594;26;F
102810;1139,1168,1131,162,1644,1576,482,1588,1311,1545,1280,1128,1421,1136,1563;56;M
102837;726,480,1311;35;M
102935;1131,1493;50;F
102949;1311,1585,1128,1563;46;M
103028;482,1128,1644,1545,1131,1588,1311;29;F
103039;480,1311,1057,1545,1644,486,1136;35;M
103107;204,581,1280,574,576,1421,482,1135,178,447,1245;39;M
103120;1135,1561,162,1412,506,1245;34;F
103130;1139,1168,1131,1311,1421,1590,1245;25;F
103164;204,1135,1131,1057,178,1561,1671,162,1412,1644,574,1128,506,1611,1245;34;F
103218;1611,1591,1545,1382,1280,574,1625,1136,447,115,1588,1139,1168,1421,1576;35;F
103253;1311,486,1131,1545,1644,1625,1573,482;28;M
103334;1311,1057,1553,160,1671,1545,162,1128,1625,1421,1136,1626,1576,480,115;36;M
103375;1139,1168,1311,1057,1553,1612,1545,162,1382,1128,1032,1245,1576,1573,482;26;M
103380;720,160,1128,1421,1136,1563,1545,1057,1311,1131,1493;34;F
103390;115,178,1626,1032,1590,1576,1493,1135,1545,574,1128,506,1245;36;F
103459;1473,1131,1545,162,1421,1136;36;M
103471;1311;25;F
103483;1128,720,726,1131,1311,1057,1553,1545,162,1280,1265,1421,1136,1576,482;25;M
103498;1131,1311,581,1057,1141,1545,1412,1280,1421,1136,506,1576,204,1135,178;40;F
103508;1265,506;65;M
103532;1545,1280,1563,1573,1588,1135,1168,1311,1002,1128,1421,486,1611,1245,482;25;F
103552;574,576,1626,447,1245,482,480,1588,1168,1311,178,1128,1265,1421,1563;47;F
103587;178,1136,480,1057,1545,162,1280,1421,1245,1576;34;F
103668;1311,1057,178,1245,1576;26;F
103689;1311,1644,1353,1421,1563,1245,1594,1576;33;M
103726;204,1135,1644,574,506,1069;30;F
103741;1069,1311,1136,1135,1591,1626,1590,506,1245,1594;44;F
103793;1545,115,720,1139,726,1563,482,1493,1421,1265,1128,1280,160,1473,1311;22;M
103844;178,162,1280,574,1244,1136,482,1311,1002,160,1128,1611,1382,1588,1168;40;F
103871;204,1139,1135,178,1545,1280,1128,1421,1136,1594,480,1644,1563,1245,482;42;F
103875;1131,1311,1128,1136,1245;37;F
103982;1135,1131,1057,1141,1353,1245,1069;36;F
104001;1265,506;36;M
104076;115,1168,1473,1545,162,1244,1493,726,1590,1612,1596,178,204,1412,1280;33;M
104081;1024,1421,482;39;M
104128;1245,1311,720;29;M
104208;482,1493,1588,1139,1135,1311,1128,1421,1545,1382,1611,1245,363,1280,1136;21;F
104219;1131,1311,1128,1421,1611,482;32;M
104238;1311,162,1280,1128,1245,482;46;M
104250;115,178;41;M
104260;204,1057,1671,1412,574,506,1069;40;F
104309;115,720,480,1588,1131,1473,1311,1002,1265,1563,1057;41;F
104348;1131,1591,1585,1545,1280,1625,1136,1311,1553,1141,1644,1128,1563,1594,482;29;F
104397;1057,178,1545,1573,720,160,162,1311,1280,1136,1135,1131,1576,1069;36;F
104417;204,1588,1168,178,1644,1596,1002,574,1265,1421,506,1563,1611,1245,1594;32;F
104544;204,720,1131,1473,1311,178,1644,1128,1265,1353;29;F
104566;1139,1131,1311,1141,1136,1576,1493;37;M
104622;1311,178,1545,1002,1168,1280,1128,1136,506,1563,1611,447,1245,1594,1493;48;F
104686;1002,1265,1421,1032,115,1139,581,162,447,1245;52;M
104728;242,1545,576,1136,447,1128,204,1588,581,1311,1612,178,1280,1611,363;39;M
104801;1591,178,1311,1588,204,480,1168,1057,1585,162,1280,1421,1626,1611,1576;54;F
104829;1563;34;M
104842;1168,1131,162,1382,574,1128,1421,115,160,1136,1545,1576,1588,1585,1611;40;M
104928;1245,1057,1585,1671,574,1128,1136,178,1561,1644,1611,204,242,1591,1412;37;F
104986;1265,1671,1412,574,1032,506,1069;8;M
105061;160,178,1591,1141,1671,162,1644,1265,1625,1611,1594,1576,1626;14;M
105106;1139,1128,506,447,482,1588,1168,1311,178,1591,1545,1382,1002,1611,1245;41;F
105132;1057,178,1545,1412,1280,1136,1032,1590,506,1576;58;F
105275;1573,1069,1128,1412,162,1545,1671,178,1057,1135,1139,720,204,1311;36;F
105350;115,1131,486,1545,1128,1136,1563,1493,1311,1280,178,1421,363,1611,1588;37;F
105437;115,480,1135,1311,160,1644,1625,1421,1136,1563,1576;55;F
105460;1136,1421,576,1356,480,1588,1135,1311,178,1545,1002,1280,1128,1245,1576;37;M
105492;242,447,1596,574,204,178;45;M
105547;1563,1576,1611,1588,1545,1311,1139,1136,1131,1128,1280,1002,482,178,115;56;M
105590;480,1588,1168,1131,1057,1553,1585,1002,1128,1421,1611;38;F
105653;1563,1128,1576,1139,726,1280,482,480,1588,1168,160,162,1382,1244,1421;30;M
105704;1588,242,1135,1311,1280,363,178,1545,1002,1421,1136,506,1611,1245,1576;48;F
105714;1611,1576,482,1594,574,1311,1168,1588,1128,1421;43;F
105716;1032,1590,1493,482,1245,1136,1128,1280,1002,1311,1131,1168,1135,1588,1545;25;F
105753;1024,1421,1644,204,242,178,1585,1545,1280,1382,1002,574,1563,1611,447;8;F
105775;486,1493,482,204,1612,1588,480,1245,1168,1585,1591,1545,1002,1136,363;44;F
105804;1545;44;F
105841;1611,115,1131,1311,178,1671,162,1412,1244,1128,1421,1353,447,1573;36;F
105991;1168,486,1421,1131,1135,1057,1545,162,1382,1280,1265,1625,1353,1136,1245;19;F
106009;486,1136,1421,1625,1265,1002,1561,720,1135,1545,1644,1280,1590,1245,1594;38;F
106048;1135,1421,1032,506,1245,115,204,1139,178,1141,162,1412,1128,1244,1265;45;F
106103;1421,486,1563,1245,1585,726,720,1131,1311,1545,1280,1128,1136,1576,482;25;F
106153;1473,1311,581,162,1644,1002,1493;32;F
106155;1311,1057,160,1128,1625,1245;35;F
106343;204,480,1024,178,1585,1545,1644,1382,1280,1002,574,1421,1563,1611,447;41;M
106559;1545,1585,1280,1128,1421,1576,482,1493,1131,1563,1168,1311,1057,447,1245;38;F
106628;115,1135,178,1545,1245;30;F
106651;1576,482,178,1311,1139,1588,1168,1591,1545,1280,1421,1136,1611,1245,363;42;F
106680;1135,1311,1545,1280,1136,1245,1576;20;F
106681;115,720,1473,1057,1545,1412,1280,1244,1136,1032,1590,1245,1576,1493;37;F
106753;720,574,506,447,1671,1412,204,1131,1057,178,1141,1265,1136,1590,1245;32;F
106882;1245,1057,160,1128,1244,1563,1611,482,1168,1002,1421,1576;37;F
106967;1131,726,1311,581,1057,160,178,1545,162,1382,1280,1136,1594,1245,1576;41;F
107005;1311,1591,1545,486,1136,1611,363,482;17;M
107007;1141,162,1588,1280,1421,1135,1057,1545,1136,506;47;F
107083;720,1311,162,1265,1590,506,1069,363;52;M
107106;1421,1590,1576,363,720,1588,1131,1311,160;40;M
107137;720,1311,1493;44;M
107221;1473,1493,115,1244,506,1590,1057,1128,1280,160,720,1136,1311,1131,1576;29;M
107229;204,1311,1057,178,1671,1421,506,1590;36;F
107254;1421,1590,363,1626,1265,1141,1591,178,204,506,1563,1245,1594,480,1644;44;M
107379;1591,1545,1280,1136,486,1611,1245,363,482;47;M
107402;1553,1545,1590,1311,1245,1493;42;M
107407;204,1131,178,1280,1136,1245;36;F
107413;1245,506,1032,1128,1473,720,1135,1311,1057,178,1545,1412,1280,1265,1136;45;F
107725;1590,1493,1069,1563,1136,1545,1588,720,1131,1311,1057,160,1591,506;34;F
107763;204,480,242,1168,1311,178,1545,162,574,1136,1563,1611,447,1245,1576;38;M
107787;1473,720,1139,1057,160,1244,1136,1590,1563,1576,115,1131,1311,1545,1128;35;F
107790;1244,720,1311,160,1057,581,1135,576,1421,1353,1136,1032,1245,1573,1069;51;F
107931;204,1588,1168,1311,1057,178,1545,1280,1421,506,447,1576,1069,482;31;F
107940;1588,178,1591,1545,1136,486,1611,1245,1576,363;19;M
107979;204,480,242,1168,1311,178,1545,162,574,1136,1563,1611,447,1245,1576;6;F
108054;1057,1421,1611;33;F
108102;1588,1139,1141,1545,1644,1136,1245,1069,204,1135,1311,1057,178,506;46;F
108108;1356,1545,1644,1002,506,1611,1576,1069;40;F
108167;1421,1128,1591,1585,1612,1168,1311,1545,1280,1136,1611,1576,482;36;F
108194;581,178,1585,1421,1136,486,506,1563,242,1057,1545,1412,1644,1353,1611;39;M
108251;1590,1493,1311,1131,1356,204,1057,178,1141,1002,1128,1136,1563,1611,1594;39;M
108315;1493;24;M
108357;1553,447,576,506,1135,1131,1311,178,1545,1280,1128,1244,1136,1032,1590;54;F
108363;1311,1585,1591,162,1265,1136,1563,1611,1594,1493,1057,1128,1244,1590,1576;26;M
108534;1135,1168,726,1131,1473,178,1545,1244,1563,1611,1576,1311,1280,1128,1136;40;F
108549;1611,1563,1265,1585,726,720,1131,1311,160,178,1128,1421,1136,1590,1493;41;M
108630;726,160,574,1136,1611,482,1493,720,1596,1421,1245,1311,162,1553,1545;31;M
108677;1311,178,1141,1136,447,1588,1168,1591,1545,1280;60;F
108811;1588,581,1585,486,1594,1069,506;33;F
108900;204,1135,1612,178,1412,1353,1590;21;F
108929;1128,1353,1561,178,1356,1245,1625,1421,447,482,242,1311,1545,506,1611;37;F
108938;1136,1421,1131,1311,1545,162,1412,1245;36;M
109040;1139,1135,1131,1311,1057,1545,1280,1128,1244,1265,1136,1032,1590,1069,1493;26;F
109131;1131,1311,1585,1591,1545,1611,447,581,1057,178,1280,574,1421,1136,1493;45;F
109206;178,1069,1311,1057,160,486,1576,1588,1136,1245,1139,1135,1131,1545,1280;34;F
109259;720,480,1139,1473,1644,1265,1493;47;F
109260;480,1311,160,482,1545,1265,1421,1136,1245,1594;24;M
109271;1588,581,1545,162,1280,1576,1135,1245,1057;33;F
109353;1576,1353,1128,1280,1311,1356,1588,1057,1612,1561,1545,1002,1611,1245,1644;33;F
109375;447,204,178,1596,574;43;F
109394;1139,1135,574,1493;27;F
109398;1002,1612,1588,1311,1057,486,447,1493,363,1585,1545,1280,1625,1136,1245;49;F
109417;1311,1644,1353,482;41;M
109568;1245,1069,1135,1131,1311,178;43;F
109598;1032,1590,1594,204,720,242,1135,726,581,178,1585,1412,574,1128,1136;48;M
109679;162,1356,480,1588,581,1057,1545,1644,1280,1136,1611,1594,1421,1245,1563;36;M
109682;204,242,1168,1311,1057,1545,1128,1069,1576,1611,1002,178,1588;35;F
109747;1131,1141,1545,1136,1626,1245,1576;32;M
109863;1625,1069,1136,1590,1563,482,1057,178,1644,574,1421,1353,506,1245,1594;66;F
109929;1588,1356,1168,1311,1057,1545,1644,1280,1128,1421,1353,1563,1611,1245,1594;31;F
109943;204,1588,1128,178,1545,1412,1644,1032,506,1611,1245,1594;43;F
110044;1245;27;F
110083;1588,1168,1311,1553,1545,1382,1002,1280,1128,1265,1625,1136,486,1611,1245;74;F
110096;1473,1493;25;F
110132;160,1671,1280,574,447,1069,363,1356,1057,1612,178,162,1644,1245;39;F
110451;115,1588,1139,726,1057,160,1545,162,1412,574,1265,1626,1611,1245,1576;35;M
110472;720,1588,1139,1585,1311,1280,1128,1545,1421,1136,1563,1611,1576,363,482;62;F
110505;581,178,576,1002,1493,1585,1563,1576,480,1136,1311,1280,1545,482,1421;54;F
110506;1473,1493;28;F
110563;204,480,1588,1057,178,1545,1412,1644,1128,1032,506,1563,1611,1245,1594;42;M
110597;726,1135,720,480,1311,1585,1002,1611,482,1588,1168,1421,1245,1576,1545;72;F
110697;1128,480,720,1168,1131,1311,1553,1591,162,1002,1280,1421,1136,486,1576;31;M
110699;1585,178,581,1139,1057,204,480,1002,1563,242,1588,1612,1591,1644,1611;36;F
110731;1057,1421,480,1131,1311,1545,1644,1128,506,1563,1611,1594,1576,363,482;49;F
110818;115,1139,178,1585,1280,1128,1136,1245,482,720,1131,1311,160,1545,1644;34;F
110829;1265,506,363,581,1135,204,1573,1131,1057,1141,1644,1421,1353,1136,1245;29;M
110865;363,1382,1545,1131,1168,1311,1057,178,1644,1002,1128,1421,1245;20;M
110871;1588,1168,1585,162,1382,1002,1128,1421,1611,482;38;M
110930;1128,1244,1265,486,1626,1032,1590,506,1563,1611,1245,1576,363;44;M
110967;1135,1131,162,486,1245;33;F
111027;1131,1311,1057,1671,1545,162,1412,1644,1382,1280,1128,1353,1136,1245,1421;42;M
111128;1591,1644,1596,482,1311,1135,1128,1265,1136,1563,1590,1611,1245,1594,1576;48;F
111209;1002,1612,1057,1131,1135,1588,204,506,1311,581,1545,1280,1136,1576,1245;26;F
111212;1421,1245,1356,1131,1612,178,1311;32;F
111218;1168,1139,115,1131,1311,178,1421,1353,1135,1265,1280,1032,204,720,1245;30;F
111231;1611,1563,1136,1128,1244,1382,1585,1057,1131,726,1168,1139,480,115,160;28;F
111244;204,242,178,1671,1545,1412,574,576,1136,1590,506,447,1245,1573,363;12;M
111453;1135,1131,1671,1412,1545,1644,1353,486,506,1563,1245,1594,1576,1069,363;33;F
111469;720,576,506,162,1131,1135,726,1311,1057,1591,1545,1280,1136,1590,1245;36;F
111500;1421,1136,1611,1245,1493,204,242,1135,1131,1057,178,1412,506,1069,363;38;F
111508;1421,162,1612,178,1311,1473,1588,115,1356,363,1131;33;M
111516;1671,576,581,204,1057,178,162,1244,1136,486,1128,1412,1545,1311,506;68;F
111609;1644,1421,1245;37;F
111664;1136,1128,1002,1585,1131,480,1588,1135,1311,1545,1644,1421,1611,1069,482;29;F
111684;1245,1588,726,1611,1576,1493,1311,1585,1545,1002,1128,1136,486,1563,1131;22;F
111685;720,480,1139,726,1311,160,1545,162,1128,1265,1421,1136,1245,1576,1131;34;F
111707;204,242,1591,581,1588,1644,1280,1128,1563,447,1311,178,1421,1611,1245;60;F
111713;1131,363,1136,1588,204,1311,1057,178,1596,1611,447,1421,1545,1135,1245;27;F
111715;178,242,204,480,1588,1311,1561,1644,574,576,1421,1353,1611,1245,1576;38;M
111741;1139,480,115,1611,486,1136,1353,1280,1545,1591,1057,1131,1588,242;30;M
111755;1002,1128,1493,720,1245,1311;61;F
111758;480,1588,1168,1311,1553,178,1585,1545,1002,1421,1136,1611,1245,1576,482;50;F
111764;1644,1585,1311,1611,1588;33;F
111809;1311,1421,1245,720,1139,1131,1545,162,1280,1136;30;M
111925;1588,1168,1382,1002,1611;41;M
111984;1612,1245,1356,1168,1561,1590,506,1069,242,1588,1591,1671,1353,1611,1576;30;F
112042;1135,1588,242,204,115,1131,1057,178,1412,1644,1128,1136,486,1611,1493;35;F
112068;1493,1612,178,162,1280,574,1265,1421,482,1135,1131,1311,1545,1136,1245;37;F
112181;1311,1644,1280,1265,1421,574,576,1353,178,1611,447,1245,1588,204,1002;58;M
112186;720,1588,1139,1131,1421;35;M
112256;1585,1382,1353,1563,1139,160,162,1128,1421,1576,1245,1136,726,1131,1311;34;F
112412;1311,1545,1002,204,720,1596;30;M
112661;720,726,1311,160,1545;37;F
112683;1265,720,1002,1493;31;F
112705;1588,1136,447,1245;29;M
112826;1131,1311,1057,1128;33;F
113021;720,1139,1131,1311,1057,178,1585,1545,162,1002,1280,1128,1421,1136,1563;45;F
113178;1141,1265,1245,1002,506,363,1493;38;M
113236;1057,1311,1168,1356,242,204,1131,1135,178,1141,162,1382,447,1245,1573;25;F
113284;1588,115,480,1139,1131,1311,178,1585,1545,1280,482,1421,1136,1563,1576;25;F
113445;160,1588,115,204,720,1139,726,1473,1311,1057,1280,1265,1136,486,1626;47;F
113467;720,1135,1131,1473,1057,1069,1493;36;F
113680;482,1611,1265,574,1002,1545,178,1168,204,1588,1139,1311,1591,1421,1594;60;M
113745;1057,1032,1590,1280,1412,1545,1671,1311,1356;33;M
113824;1576,1245,1128,1588,1135,1168,1311,1585,1545,1002,1280,1625,1421,1353,1611;29;F
113896;1136,204,480,242,1135,1131,1311,1057,178,1545,1412,574,1353,1563,1245;34;F
114093;482,1245,178,1585,1128,1265,506,1573,1493,1311,1131,480,720,1545,1644;26;M
114124;1545,1244,1265,506,1576,1311,1493;42;M
114138;1057,1131,720,1311,178,1545,1280,1128,1244,1265,576,1136,506,1245;53;F
114249;1139,720,115,1473,581,1545,1412,1265,576,506,1493,204,1057,447,1245;47;F
114390;1139,1311,1553,1644,1128,1563,1611,1245,1069;48;F
114420;1311,1128,1245,1280,1136,486,1032,363;45;M
114431;720,1612,1280,1131,1311,581,1057,1412;34;M
114432;1596,178,204,1356,1590,506,1671,1612,1245,1057,1412,1136,1131,1553,1280;33;F
114552;506;5;F
114599;242,1139,1135,1131,1311,1612,178,1561,1545,1412,1644,1280,1625,1136,1245;43;F
114743;506;8;F
114802;1412,576,1128,1280,1473,115,720,1545,1244,1032,1590,1136,1245,1493,1057;44;F
114831;1311;36;F
114881;1135,1545,1625,1136,1590,506,1069;62;F
115042;506;39;M
115050;480,1131,178,1545,1280,1128,1421,1136,1245,1576;35;M
115056;1131,1311,1057,1545,162,1412,1280,1128,1265,1421,1136;29;F
115159;1168,1311,1057,1644,1002,1280,1128,1421,1626;31;F
115169;1421,1032,506,1563,1611,1069,1493,482,115,480,726,1131,1311,1576;37;M
115176;1611,1563,1136,1585,115,726,1131,1311,178,1545,1644,1128,1265,482,1245;25;F
115203;1545,1131,1135,204,115,1057,1245,482,1356,1139,1311,1553,1596,1382,1280;18;M
115206;204,480,1139,1131,1311,1553,1612,178,1591,1545,1382,1128,1136;57;F
115352;1135,1311,1128,1594,1573,482;27;F
115377;1128;44;F
115387;1612,1588,204,115,1139,1135,1131,1473,1311,1057,1141,162,1644,506,1493;36;F
115623;1588;36;M
115659;204,242,480,1139,1311,1057,1671,1644,1280,1128,1265,576,1136,506,447;39;F
115709;1644,726,1139,1588,480,1135,1168,1057,178,1141,1136,1245;27;F
115866;1563,1245,363,482,581,1057,1002,1421,204,480,1139,178,1545,1128,1611;39;M
116206;1644,1493,1473,1141,1057,1032,1002,1590,1265,1311,581,506,1139,720,1128;24;M
116221;1644,1625,1493,1421,1057,1032,1590,1265,1311,581,178,506,1139,720,1128;50;F
116225;1611,1280,1576,1545,506,1136;75;M
116229;178;73;F
116233;178;69;M
116240;1057,1032,1139;47;M
999999104227;482;31;F